/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.EssentialsC.version.resolver;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.EssC;
import net.godlycow.org.util.logger.AnsiColorUtil;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.json.JSONArray;
import org.json.JSONObject;

public class VersionChecker {
    private static final String MODRINTH_PROJECT_ID = "K7HZMVgx";
    private static String latestVersion = "unknown";
    private static final MiniMessage MINI = MiniMessage.miniMessage();

    public static void checkLatestVersion(Plugin plugin) {
        HttpClient client = HttpClient.newHttpClient();
        String url = "https://api.modrinth.com/v2/project/K7HZMVgx/version";
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).build();
        ((CompletableFuture)((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenAccept(response -> {
            try {
                JSONArray versions = new JSONArray((String)response);
                if (versions.length() > 0) {
                    JSONObject latest = versions.getJSONObject(0);
                    latestVersion = latest.getString("version_number");
                    String currentVersion = plugin.getDescription().getVersion();
                    String graySep = AnsiColorUtil.colorize("#9B9B9B", "================================");
                    String grayDash = AnsiColorUtil.colorize("#9B9B9B", "--------------------------------");
                    Bukkit.getLogger().info("");
                    Bukkit.getLogger().info(graySep);
                    if (!currentVersion.equalsIgnoreCase(latestVersion)) {
                        Bukkit.getLogger().info(AnsiColorUtil.warning("EssentialsC") + AnsiColorUtil.colorize("#9B9B9B", " - ") + AnsiColorUtil.warning("Update Available"));
                        Bukkit.getLogger().info(grayDash);
                        Bukkit.getLogger().info(AnsiColorUtil.secondary("Current: ") + AnsiColorUtil.danger(currentVersion));
                        Bukkit.getLogger().info(AnsiColorUtil.secondary("Latest: ") + AnsiColorUtil.success(latestVersion));
                        Bukkit.getLogger().info(AnsiColorUtil.secondary("Download: ") + AnsiColorUtil.info("https://modrinth.com/plugin/essentialsc"));
                    } else {
                        Bukkit.getLogger().info(AnsiColorUtil.warning("EssentialsC") + AnsiColorUtil.colorize("#9B9B9B", " - ") + AnsiColorUtil.success("Up To Date"));
                        Bukkit.getLogger().info(grayDash);
                        Bukkit.getLogger().info(AnsiColorUtil.secondary("Running latest version: ") + AnsiColorUtil.success(currentVersion));
                    }
                    Bukkit.getLogger().info(graySep);
                    Bukkit.getLogger().info("");
                }
            }
            catch (Exception e) {
                String graySep = AnsiColorUtil.colorize("#9B9B9B", "================================");
                Bukkit.getLogger().warning(graySep);
                Bukkit.getLogger().warning(AnsiColorUtil.danger("Failed to parse version data from Modrinth."));
                Bukkit.getLogger().warning(graySep);
            }
        })).exceptionally(e -> {
            String graySep = AnsiColorUtil.colorize("#9B9B9B", "================================");
            Bukkit.getLogger().warning(graySep);
            Bukkit.getLogger().warning(AnsiColorUtil.danger("Could not fetch latest version from Modrinth."));
            Bukkit.getLogger().warning(graySep);
            return null;
        });
    }

    public static void notifyIfOutdated(Player player) {
        String currentVersion = EssC.getInstance().getDescription().getVersion();
        String latest = VersionChecker.getLatestVersion();
        if (!latest.equals("unknown") && !currentVersion.equals(latest) && (player.hasPermission("essc.version.notify") || player.isOp())) {
            player.sendMessage(MINI.deserialize("<gray> </gray>"));
            player.sendMessage(MINI.deserialize("<gray>================================</gray>"));
            player.sendMessage(MINI.deserialize("<gradient:#FFCC33:#FFF2AA>EssentialsC - Update Available</gradient>"));
            player.sendMessage(MINI.deserialize("<gray>--------------------------------</gray>"));
            player.sendMessage(MINI.deserialize("<gray>Current: </gray><red>" + currentVersion + "</red>"));
            player.sendMessage(MINI.deserialize("<gray>Latest: </gray><green>" + latest + "</green>"));
            player.sendMessage(MINI.deserialize("<gray>Download: </gray><aqua>https://modrinth.com/plugin/essentialsc</aqua>"));
            player.sendMessage(MINI.deserialize("<gray>================================</gray>"));
            player.sendMessage(MINI.deserialize("<gray> </gray>"));
        }
    }

    public static String getCurrentVersion() {
        return EssC.getInstance().getDescription().getVersion();
    }

    public static String getLatestVersion() {
        return latestVersion;
    }
}

