/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.warp.event;

import com.serveressentials.api.warp.event.WarpEvent;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WarpDeleteEvent
extends WarpEvent {
    @NotNull
    private final String warpName;
    @Nullable
    private final UUID deletedBy;

    public WarpDeleteEvent(@NotNull Player player, @NotNull String warpName, @Nullable UUID deletedBy) {
        super(player);
        this.warpName = Objects.requireNonNull(warpName, "warpName cannot be null");
        this.deletedBy = deletedBy;
    }

    @NotNull
    public String getWarpName() {
        return this.warpName;
    }

    @Nullable
    public UUID getDeletedBy() {
        return this.deletedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WarpDeleteEvent that = (WarpDeleteEvent)((Object)o);
        return Objects.equals(this.warpName, that.warpName) && Objects.equals(this.deletedBy, that.deletedBy);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.warpName, this.deletedBy);
    }

    @NotNull
    public String toString() {
        return "WarpDeleteEvent{player=" + this.getPlayer().getName() + ", warpName='" + this.warpName + "', deletedBy=" + String.valueOf(this.deletedBy) + "}";
    }
}

