/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.warp;

import java.time.Duration;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class WarpSettings {
    @NotNull
    private final Duration cooldown;
    private final int defaultMaxWarps;

    public WarpSettings(@NotNull Duration cooldown, int defaultMaxWarps) {
        this.cooldown = Objects.requireNonNull(cooldown, "cooldown cannot be null");
        this.defaultMaxWarps = defaultMaxWarps;
    }

    @NotNull
    public Duration getCooldown() {
        return this.cooldown;
    }

    public int getDefaultMaxWarps() {
        return this.defaultMaxWarps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WarpSettings that = (WarpSettings)o;
        return this.defaultMaxWarps == that.defaultMaxWarps && Objects.equals(this.cooldown, that.cooldown);
    }

    public int hashCode() {
        return Objects.hash(this.cooldown, this.defaultMaxWarps);
    }

    @NotNull
    public String toString() {
        return "WarpSettings{cooldown=" + String.valueOf(this.cooldown) + ", defaultMaxWarps=" + this.defaultMaxWarps + "}";
    }
}

