/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.warp;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class WarpLocation {
    @NotNull
    private final String world;
    private final double x;
    private final double y;
    private final double z;
    private final float yaw;
    private final float pitch;

    public WarpLocation(@NotNull String world, double x, double y, double z, float yaw, float pitch) {
        this.world = Objects.requireNonNull(world, "world cannot be null");
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    @NotNull
    public String getWorld() {
        return this.world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WarpLocation that = (WarpLocation)o;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0 && Double.compare(that.z, this.z) == 0 && Float.compare(that.yaw, this.yaw) == 0 && Float.compare(that.pitch, this.pitch) == 0 && Objects.equals(this.world, that.world);
    }

    public int hashCode() {
        return Objects.hash(this.world, this.x, this.y, this.z, Float.valueOf(this.yaw), Float.valueOf(this.pitch));
    }

    @NotNull
    public String toString() {
        return "WarpLocation{world='" + this.world + "', x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", yaw=" + this.yaw + ", pitch=" + this.pitch + "}";
    }
}

