/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.warp;

import com.serveressentials.api.warp.WarpLocation;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class WarpData {
    @NotNull
    private final String name;
    @NotNull
    private final WarpLocation location;
    @NotNull
    private final UUID creator;

    public WarpData(@NotNull String name, @NotNull WarpLocation location, @NotNull UUID creator) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.location = Objects.requireNonNull(location, "location cannot be null");
        this.creator = Objects.requireNonNull(creator, "creator cannot be null");
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public WarpLocation getLocation() {
        return this.location;
    }

    @NotNull
    public UUID getCreator() {
        return this.creator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WarpData warpData = (WarpData)o;
        return Objects.equals(this.name, warpData.name) && Objects.equals(this.location, warpData.location) && Objects.equals(this.creator, warpData.creator);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.location, this.creator);
    }

    @NotNull
    public String toString() {
        return "WarpData{name='" + this.name + "', location=" + String.valueOf(this.location) + ", creator=" + String.valueOf(this.creator) + "}";
    }
}

