/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.tpa;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class TPASettings {
    private final int cooldown;
    private final int timeout;
    private final int warmup;
    private final int teleportDelay;
    private final boolean cancelOnMove;
    private final boolean blockMoveThresholdBlocks;
    private final boolean crossWorld;
    @NotNull
    private final List<String> blockedWorlds;
    private final boolean economyEnabled;
    private final boolean particlesEnabled;
    @NotNull
    private final String particleType;

    public TPASettings(int cooldown, int timeout, int warmup, int teleportDelay, boolean cancelOnMove, boolean blockMoveThresholdBlocks, boolean crossWorld, @NotNull List<String> blockedWorlds, boolean economyEnabled, boolean particlesEnabled, @NotNull String particleType) {
        this.cooldown = cooldown;
        this.timeout = timeout;
        this.warmup = warmup;
        this.teleportDelay = teleportDelay;
        this.cancelOnMove = cancelOnMove;
        this.blockMoveThresholdBlocks = blockMoveThresholdBlocks;
        this.crossWorld = crossWorld;
        this.blockedWorlds = Objects.requireNonNull(blockedWorlds, "blockedWorlds cannot be null");
        this.economyEnabled = economyEnabled;
        this.particlesEnabled = particlesEnabled;
        this.particleType = Objects.requireNonNull(particleType, "particleType cannot be null");
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getWarmup() {
        return this.warmup;
    }

    public int getTeleportDelay() {
        return this.teleportDelay;
    }

    public boolean isCancelOnMove() {
        return this.cancelOnMove;
    }

    public boolean isBlockMoveThresholdBlocks() {
        return this.blockMoveThresholdBlocks;
    }

    public boolean isCrossWorld() {
        return this.crossWorld;
    }

    @NotNull
    public List<String> getBlockedWorlds() {
        return this.blockedWorlds;
    }

    public boolean isEconomyEnabled() {
        return this.economyEnabled;
    }

    public boolean isParticlesEnabled() {
        return this.particlesEnabled;
    }

    @NotNull
    public String getParticleType() {
        return this.particleType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPASettings that = (TPASettings)o;
        return this.cooldown == that.cooldown && this.timeout == that.timeout && this.warmup == that.warmup && this.teleportDelay == that.teleportDelay && this.cancelOnMove == that.cancelOnMove && this.blockMoveThresholdBlocks == that.blockMoveThresholdBlocks && this.crossWorld == that.crossWorld && this.economyEnabled == that.economyEnabled && this.particlesEnabled == that.particlesEnabled && Objects.equals(this.blockedWorlds, that.blockedWorlds) && Objects.equals(this.particleType, that.particleType);
    }

    public int hashCode() {
        return Objects.hash(this.cooldown, this.timeout, this.warmup, this.teleportDelay, this.cancelOnMove, this.blockMoveThresholdBlocks, this.crossWorld, this.blockedWorlds, this.economyEnabled, this.particlesEnabled, this.particleType);
    }

    @NotNull
    public String toString() {
        return "TPASettings{cooldown=" + this.cooldown + ", timeout=" + this.timeout + ", warmup=" + this.warmup + ", teleportDelay=" + this.teleportDelay + ", cancelOnMove=" + this.cancelOnMove + ", blockMoveThresholdBlocks=" + this.blockMoveThresholdBlocks + ", crossWorld=" + this.crossWorld + ", blockedWorlds=" + String.valueOf(this.blockedWorlds) + ", economyEnabled=" + this.economyEnabled + ", particlesEnabled=" + this.particlesEnabled + ", particleType='" + this.particleType + "'}";
    }
}

