/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.tpa;

import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class TPARequestData {
    @NotNull
    private final UUID senderId;
    @NotNull
    private final UUID targetId;
    private final boolean here;
    private final double cost;
    private final long timestamp;

    public TPARequestData(@NotNull UUID senderId, @NotNull UUID targetId, boolean here, double cost, long timestamp) {
        this.senderId = Objects.requireNonNull(senderId, "senderId cannot be null");
        this.targetId = Objects.requireNonNull(targetId, "targetId cannot be null");
        this.here = here;
        this.cost = cost;
        this.timestamp = timestamp;
    }

    @NotNull
    public UUID getSenderId() {
        return this.senderId;
    }

    @NotNull
    public UUID getTargetId() {
        return this.targetId;
    }

    public boolean isHere() {
        return this.here;
    }

    public double getCost() {
        return this.cost;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPARequestData that = (TPARequestData)o;
        return this.here == that.here && Double.compare(that.cost, this.cost) == 0 && this.timestamp == that.timestamp && Objects.equals(this.senderId, that.senderId) && Objects.equals(this.targetId, that.targetId);
    }

    public int hashCode() {
        return Objects.hash(this.senderId, this.targetId, this.here, this.cost, this.timestamp);
    }

    @NotNull
    public String toString() {
        return "TPARequestData{senderId=" + String.valueOf(this.senderId) + ", targetId=" + String.valueOf(this.targetId) + ", here=" + this.here + ", cost=" + this.cost + ", timestamp=" + this.timestamp + "}";
    }
}

