/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.tpa;

import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class TPAPlayerData {
    @NotNull
    private final UUID playerId;
    private final long cooldownTime;
    private final boolean requestsDisabled;
    private final int activeRequestsSent;
    private final int activeRequestsReceived;

    public TPAPlayerData(@NotNull UUID playerId, long cooldownTime, boolean requestsDisabled, int activeRequestsSent, int activeRequestsReceived) {
        this.playerId = Objects.requireNonNull(playerId, "playerId cannot be null");
        this.cooldownTime = cooldownTime;
        this.requestsDisabled = requestsDisabled;
        this.activeRequestsSent = activeRequestsSent;
        this.activeRequestsReceived = activeRequestsReceived;
    }

    @NotNull
    public UUID getPlayerId() {
        return this.playerId;
    }

    public long getCooldownTime() {
        return this.cooldownTime;
    }

    public boolean isRequestsDisabled() {
        return this.requestsDisabled;
    }

    public int getActiveRequestsSent() {
        return this.activeRequestsSent;
    }

    public int getActiveRequestsReceived() {
        return this.activeRequestsReceived;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPAPlayerData that = (TPAPlayerData)o;
        return this.cooldownTime == that.cooldownTime && this.requestsDisabled == that.requestsDisabled && this.activeRequestsSent == that.activeRequestsSent && this.activeRequestsReceived == that.activeRequestsReceived && Objects.equals(this.playerId, that.playerId);
    }

    public int hashCode() {
        return Objects.hash(this.playerId, this.cooldownTime, this.requestsDisabled, this.activeRequestsSent, this.activeRequestsReceived);
    }

    @NotNull
    public String toString() {
        return "TPAPlayerData{playerId=" + String.valueOf(this.playerId) + ", cooldownTime=" + this.cooldownTime + ", requestsDisabled=" + this.requestsDisabled + ", activeRequestsSent=" + this.activeRequestsSent + ", activeRequestsReceived=" + this.activeRequestsReceived + "}";
    }
}

