/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.shop;

import com.serveressentials.api.shop.ShopItem;
import com.serveressentials.api.shop.ShopLayout;
import java.util.Collections;
import java.util.Map;

public class ShopSection {
    private final String title;
    private final int size;
    private final int pages;
    private final int playerHeadSlot;
    private final int closeButtonSlot;
    private final Map<Integer, ShopLayout> layout;
    private final Map<String, ShopItem> items;

    public ShopSection(String title, int size, int pages, int playerHeadSlot, int closeButtonSlot, Map<Integer, ShopLayout> layout, Map<String, ShopItem> items) {
        this.title = title;
        this.size = size;
        this.pages = pages;
        this.playerHeadSlot = playerHeadSlot;
        this.closeButtonSlot = closeButtonSlot;
        this.layout = Map.copyOf(layout);
        this.items = Map.copyOf(items);
    }

    public String getTitle() {
        return this.title;
    }

    public int getSize() {
        return this.size;
    }

    public int getPages() {
        return this.pages;
    }

    public int getPlayerHeadSlot() {
        return this.playerHeadSlot;
    }

    public int getCloseButtonSlot() {
        return this.closeButtonSlot;
    }

    public Map<Integer, ShopLayout> getLayout() {
        return Collections.unmodifiableMap(this.layout);
    }

    public Map<String, ShopItem> getItems() {
        return Collections.unmodifiableMap(this.items);
    }
}

