/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.shop;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.bukkit.Material;

public class ShopItem {
    private final Material material;
    private final int amount;
    private final String name;
    private final List<String> lore;
    private final double buyPrice;
    private final double sellPrice;
    private final String customItemId;
    private final int slot;
    private final int page;
    private final boolean clickable;

    public ShopItem(Material material, int amount, String name, List<String> lore, double buyPrice, double sellPrice, String customItemId, int slot, int page, boolean clickable) {
        this.material = material;
        this.amount = amount;
        this.name = name;
        this.lore = List.copyOf(lore != null ? lore : List.of());
        this.buyPrice = buyPrice;
        this.sellPrice = sellPrice;
        this.customItemId = customItemId;
        this.slot = slot;
        this.page = page;
        this.clickable = clickable;
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getAmount() {
        return this.amount;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLore() {
        return Collections.unmodifiableList(this.lore);
    }

    public double getBuyPrice() {
        return this.buyPrice;
    }

    public double getSellPrice() {
        return this.sellPrice;
    }

    public Optional<String> getCustomItemId() {
        return Optional.ofNullable(this.customItemId);
    }

    public int getSlot() {
        return this.slot;
    }

    public int getPage() {
        return this.page;
    }

    public boolean isClickable() {
        return this.clickable;
    }
}

