/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.sellgui.event;

import com.serveressentials.api.sellgui.event.SellGUIEvent;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class SellGUIItemSellEvent
extends SellGUIEvent {
    @NotNull
    private final Material material;
    private final int quantity;
    private final double pricePerItem;
    private final double totalPrice;

    public SellGUIItemSellEvent(@NotNull Player player, @NotNull Material material, int quantity, double pricePerItem, double totalPrice) {
        super(player);
        this.material = Objects.requireNonNull(material, "material cannot be null");
        this.quantity = quantity;
        this.pricePerItem = pricePerItem;
        this.totalPrice = totalPrice;
    }

    @NotNull
    public Material getMaterial() {
        return this.material;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public double getPricePerItem() {
        return this.pricePerItem;
    }

    public double getTotalPrice() {
        return this.totalPrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SellGUIItemSellEvent that = (SellGUIItemSellEvent)((Object)o);
        return this.quantity == that.quantity && Double.compare(that.pricePerItem, this.pricePerItem) == 0 && Double.compare(that.totalPrice, this.totalPrice) == 0 && this.material == that.material;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.material, this.quantity, this.pricePerItem, this.totalPrice);
    }

    @NotNull
    public String toString() {
        return "SellGUIItemSellEvent{player=" + this.getPlayer().getName() + ", material=" + String.valueOf(this.material) + ", quantity=" + this.quantity + ", pricePerItem=" + this.pricePerItem + ", totalPrice=" + this.totalPrice + "}";
    }
}

