/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.sellgui;

import java.util.Objects;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;

public final class SellableItem {
    @NotNull
    private final Material material;
    private final double price;

    public SellableItem(@NotNull Material material, double price) {
        this.material = Objects.requireNonNull(material, "material cannot be null");
        this.price = price;
    }

    @NotNull
    public Material getMaterial() {
        return this.material;
    }

    public double getPrice() {
        return this.price;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SellableItem that = (SellableItem)o;
        return Double.compare(that.price, this.price) == 0 && this.material == that.material;
    }

    public int hashCode() {
        return Objects.hash(this.material, this.price);
    }

    @NotNull
    public String toString() {
        return "SellableItem{material=" + String.valueOf(this.material) + ", price=" + this.price + "}";
    }
}

