/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.sellgui;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;

public final class SellTransaction {
    @NotNull
    private final UUID playerId;
    @NotNull
    private final String playerName;
    @NotNull
    private final Material material;
    private final int quantity;
    private final double pricePerItem;
    private final double totalPrice;
    private final long timestamp;

    public SellTransaction(@NotNull UUID playerId, @NotNull String playerName, @NotNull Material material, int quantity, double pricePerItem, double totalPrice, long timestamp) {
        this.playerId = Objects.requireNonNull(playerId, "playerId cannot be null");
        this.playerName = Objects.requireNonNull(playerName, "playerName cannot be null");
        this.material = Objects.requireNonNull(material, "material cannot be null");
        this.quantity = quantity;
        this.pricePerItem = pricePerItem;
        this.totalPrice = totalPrice;
        this.timestamp = timestamp;
    }

    @NotNull
    public UUID getPlayerId() {
        return this.playerId;
    }

    @NotNull
    public String getPlayerName() {
        return this.playerName;
    }

    @NotNull
    public Material getMaterial() {
        return this.material;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public double getPricePerItem() {
        return this.pricePerItem;
    }

    public double getTotalPrice() {
        return this.totalPrice;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SellTransaction that = (SellTransaction)o;
        return this.quantity == that.quantity && Double.compare(that.pricePerItem, this.pricePerItem) == 0 && Double.compare(that.totalPrice, this.totalPrice) == 0 && this.timestamp == that.timestamp && Objects.equals(this.playerId, that.playerId) && Objects.equals(this.playerName, that.playerName) && this.material == that.material;
    }

    public int hashCode() {
        return Objects.hash(this.playerId, this.playerName, this.material, this.quantity, this.pricePerItem, this.totalPrice, this.timestamp);
    }

    @NotNull
    public String toString() {
        return "SellTransaction{playerId=" + String.valueOf(this.playerId) + ", playerName='" + this.playerName + "', material=" + String.valueOf(this.material) + ", quantity=" + this.quantity + ", pricePerItem=" + this.pricePerItem + ", totalPrice=" + this.totalPrice + ", timestamp=" + this.timestamp + "}";
    }
}

