/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.scoreboard.event;

import com.serveressentials.api.scoreboard.event.ScoreboardEvent;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScoreboardLayoutChangeEvent
extends ScoreboardEvent {
    @NotNull
    private final String newLayout;
    @Nullable
    private final String previousLayout;

    public ScoreboardLayoutChangeEvent(@NotNull Player player, @NotNull String newLayout, @Nullable String previousLayout) {
        super(player);
        this.newLayout = Objects.requireNonNull(newLayout, "newLayout cannot be null");
        this.previousLayout = previousLayout;
    }

    @NotNull
    public String getNewLayout() {
        return this.newLayout;
    }

    @Nullable
    public String getPreviousLayout() {
        return this.previousLayout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScoreboardLayoutChangeEvent that = (ScoreboardLayoutChangeEvent)((Object)o);
        return Objects.equals(this.newLayout, that.newLayout) && Objects.equals(this.previousLayout, that.previousLayout);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.newLayout, this.previousLayout);
    }

    @NotNull
    public String toString() {
        return "ScoreboardLayoutChangeEvent{player=" + this.getPlayer().getName() + ", newLayout='" + this.newLayout + "', previousLayout='" + this.previousLayout + "'}";
    }
}

