/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.scoreboard;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class ScoreboardLayout {
    @NotNull
    private final String title;
    @NotNull
    private final List<String> lines;
    private final int maxLines;

    public ScoreboardLayout(@NotNull String title, @NotNull List<String> lines, int maxLines) {
        this.title = Objects.requireNonNull(title, "title cannot be null");
        this.lines = Objects.requireNonNull(lines, "lines cannot be null");
        this.maxLines = maxLines;
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    @NotNull
    public List<String> getLines() {
        return this.lines;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScoreboardLayout that = (ScoreboardLayout)o;
        return this.maxLines == that.maxLines && Objects.equals(this.title, that.title) && Objects.equals(this.lines, that.lines);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.lines, this.maxLines);
    }

    @NotNull
    public String toString() {
        return "ScoreboardLayout{title='" + this.title + "', lines=" + String.valueOf(this.lines) + ", maxLines=" + this.maxLines + "}";
    }
}

