/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.rtp;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class RtpWorldConfig {
    @NotNull
    private final String worldName;
    private final boolean enabled;
    private final int minRadius;
    private final int maxRadius;
    private final int cooldownSeconds;

    public RtpWorldConfig(@NotNull String worldName, boolean enabled, int minRadius, int maxRadius, int cooldownSeconds) {
        this.worldName = Objects.requireNonNull(worldName, "worldName cannot be null");
        this.enabled = enabled;
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
        this.cooldownSeconds = cooldownSeconds;
    }

    @NotNull
    public String getWorldName() {
        return this.worldName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMinRadius() {
        return this.minRadius;
    }

    public int getMaxRadius() {
        return this.maxRadius;
    }

    public int getCooldownSeconds() {
        return this.cooldownSeconds;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RtpWorldConfig)) {
            return false;
        }
        RtpWorldConfig that = (RtpWorldConfig)obj;
        return this.enabled == that.enabled && this.minRadius == that.minRadius && this.maxRadius == that.maxRadius && this.cooldownSeconds == that.cooldownSeconds && this.worldName.equals(that.worldName);
    }

    public int hashCode() {
        return Objects.hash(this.worldName, this.enabled, this.minRadius, this.maxRadius, this.cooldownSeconds);
    }

    public String toString() {
        return "RtpWorldConfig{worldName='" + this.worldName + "', enabled=" + this.enabled + ", minRadius=" + this.minRadius + ", maxRadius=" + this.maxRadius + ", cooldownSeconds=" + this.cooldownSeconds + "}";
    }
}

