/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.rtp;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public final class RtpLocation {
    @NotNull
    private final UUID playerId;
    @NotNull
    private final String playerName;
    @NotNull
    private final String worldName;
    private final double x;
    private final double y;
    private final double z;
    private final long timestamp;

    public RtpLocation(@NotNull UUID playerId, @NotNull String playerName, @NotNull String worldName, double x, double y, double z, long timestamp) {
        this.playerId = Objects.requireNonNull(playerId, "playerId cannot be null");
        this.playerName = Objects.requireNonNull(playerName, "playerName cannot be null");
        this.worldName = Objects.requireNonNull(worldName, "worldName cannot be null");
        this.x = x;
        this.y = y;
        this.z = z;
        this.timestamp = timestamp;
    }

    @NotNull
    public UUID getPlayerId() {
        return this.playerId;
    }

    @NotNull
    public String getPlayerName() {
        return this.playerName;
    }

    @NotNull
    public String getWorldName() {
        return this.worldName;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Location toLocation(@NotNull World world) {
        return new Location(world, this.x, this.y, this.z);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RtpLocation)) {
            return false;
        }
        RtpLocation that = (RtpLocation)obj;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0 && Double.compare(that.z, this.z) == 0 && this.timestamp == that.timestamp && this.playerId.equals(that.playerId) && this.playerName.equals(that.playerName) && this.worldName.equals(that.worldName);
    }

    public int hashCode() {
        return Objects.hash(this.playerId, this.playerName, this.worldName, this.x, this.y, this.z, this.timestamp);
    }

    public String toString() {
        return "RtpLocation{playerId=" + String.valueOf(this.playerId) + ", playerName='" + this.playerName + "', worldName='" + this.worldName + "', x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", timestamp=" + this.timestamp + "}";
    }
}

