/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.report;

import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReportInfo {
    @NotNull
    private final String id;
    @NotNull
    private final UUID reporterId;
    @NotNull
    private final UUID targetId;
    @NotNull
    private final String reason;
    private final long timestamp;
    private final boolean pending;
    @Nullable
    private final String reporterName;
    @Nullable
    private final String targetName;

    public ReportInfo(@NotNull String id, @NotNull UUID reporterId, @NotNull UUID targetId, @NotNull String reason, long timestamp, boolean pending, @Nullable String reporterName, @Nullable String targetName) {
        this.id = Objects.requireNonNull(id, "id cannot be null");
        this.reporterId = Objects.requireNonNull(reporterId, "reporterId cannot be null");
        this.targetId = Objects.requireNonNull(targetId, "targetId cannot be null");
        this.reason = Objects.requireNonNull(reason, "reason cannot be null");
        this.timestamp = timestamp;
        this.pending = pending;
        this.reporterName = reporterName;
        this.targetName = targetName;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public UUID getReporterId() {
        return this.reporterId;
    }

    @NotNull
    public UUID getTargetId() {
        return this.targetId;
    }

    @NotNull
    public String getReason() {
        return this.reason;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isPending() {
        return this.pending;
    }

    @Nullable
    public String getReporterName() {
        return this.reporterName;
    }

    @Nullable
    public String getTargetName() {
        return this.targetName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ReportInfo)) {
            return false;
        }
        ReportInfo that = (ReportInfo)obj;
        return this.timestamp == that.timestamp && this.pending == that.pending && this.id.equals(that.id) && this.reporterId.equals(that.reporterId) && this.targetId.equals(that.targetId) && this.reason.equals(that.reason) && Objects.equals(this.reporterName, that.reporterName) && Objects.equals(this.targetName, that.targetName);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.reporterId, this.targetId, this.reason, this.timestamp, this.pending, this.reporterName, this.targetName);
    }

    public String toString() {
        return "ReportInfo{id='" + this.id + "', reporterId=" + String.valueOf(this.reporterId) + ", targetId=" + String.valueOf(this.targetId) + ", reason='" + this.reason + "', timestamp=" + this.timestamp + ", pending=" + this.pending + ", reporterName='" + this.reporterName + "', targetName='" + this.targetName + "'}";
    }
}

