/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.nick;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class NickValidationRules {
    private final int minLength;
    private final int maxLength;
    private final boolean allowFormatting;
    private final boolean allowReset;
    private final boolean allowDuplicates;
    private final int cooldown;
    private final int maxChangesPerDay;
    @NotNull
    private final List<String> blockedWords;
    @NotNull
    private final List<String> blacklistPatterns;

    public NickValidationRules(int minLength, int maxLength, boolean allowFormatting, boolean allowReset, boolean allowDuplicates, int cooldown, int maxChangesPerDay, @NotNull List<String> blockedWords, @NotNull List<String> blacklistPatterns) {
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.allowFormatting = allowFormatting;
        this.allowReset = allowReset;
        this.allowDuplicates = allowDuplicates;
        this.cooldown = cooldown;
        this.maxChangesPerDay = maxChangesPerDay;
        this.blockedWords = Objects.requireNonNull(blockedWords, "blockedWords cannot be null");
        this.blacklistPatterns = Objects.requireNonNull(blacklistPatterns, "blacklistPatterns cannot be null");
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public boolean isAllowFormatting() {
        return this.allowFormatting;
    }

    public boolean isAllowReset() {
        return this.allowReset;
    }

    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getMaxChangesPerDay() {
        return this.maxChangesPerDay;
    }

    @NotNull
    public List<String> getBlockedWords() {
        return List.copyOf(this.blockedWords);
    }

    @NotNull
    public List<String> getBlacklistPatterns() {
        return List.copyOf(this.blacklistPatterns);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NickValidationRules)) {
            return false;
        }
        NickValidationRules that = (NickValidationRules)obj;
        return this.minLength == that.minLength && this.maxLength == that.maxLength && this.allowFormatting == that.allowFormatting && this.allowReset == that.allowReset && this.allowDuplicates == that.allowDuplicates && this.cooldown == that.cooldown && this.maxChangesPerDay == that.maxChangesPerDay && this.blockedWords.equals(that.blockedWords) && this.blacklistPatterns.equals(that.blacklistPatterns);
    }

    public int hashCode() {
        return Objects.hash(this.minLength, this.maxLength, this.allowFormatting, this.allowReset, this.allowDuplicates, this.cooldown, this.maxChangesPerDay, this.blockedWords, this.blacklistPatterns);
    }

    public String toString() {
        return "NickValidationRules{minLength=" + this.minLength + ", maxLength=" + this.maxLength + ", allowFormatting=" + this.allowFormatting + ", allowReset=" + this.allowReset + ", allowDuplicates=" + this.allowDuplicates + ", cooldown=" + this.cooldown + ", maxChangesPerDay=" + this.maxChangesPerDay + ", blockedWords=" + String.valueOf(this.blockedWords) + ", blacklistPatterns=" + String.valueOf(this.blacklistPatterns) + "}";
    }
}

