/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.nick;

import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class NickInfo {
    @NotNull
    private final UUID playerId;
    @NotNull
    private final String playerName;
    @NotNull
    private final String nickname;
    private final long timestamp;
    private final int changesToday;

    public NickInfo(@NotNull UUID playerId, @NotNull String playerName, @NotNull String nickname, long timestamp, int changesToday) {
        this.playerId = Objects.requireNonNull(playerId, "playerId cannot be null");
        this.playerName = Objects.requireNonNull(playerName, "playerName cannot be null");
        this.nickname = Objects.requireNonNull(nickname, "nickname cannot be null");
        this.timestamp = timestamp;
        this.changesToday = changesToday;
    }

    @NotNull
    public UUID getPlayerId() {
        return this.playerId;
    }

    @NotNull
    public String getPlayerName() {
        return this.playerName;
    }

    @NotNull
    public String getNickname() {
        return this.nickname;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getChangesToday() {
        return this.changesToday;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NickInfo)) {
            return false;
        }
        NickInfo that = (NickInfo)obj;
        return this.timestamp == that.timestamp && this.changesToday == that.changesToday && this.playerId.equals(that.playerId) && this.playerName.equals(that.playerName) && this.nickname.equals(that.nickname);
    }

    public int hashCode() {
        return Objects.hash(this.playerId, this.playerName, this.nickname, this.timestamp, this.changesToday);
    }

    public String toString() {
        return "NickInfo{playerId=" + String.valueOf(this.playerId) + ", playerName='" + this.playerName + "', nickname='" + this.nickname + "', timestamp=" + this.timestamp + ", changesToday=" + this.changesToday + "}";
    }
}

