/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.mail;

import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class MailStats {
    @NotNull
    private final UUID playerId;
    private final int totalCount;
    private final int unreadCount;
    private final long lastActivity;

    public MailStats(@NotNull UUID playerId, int totalCount, int unreadCount, long lastActivity) {
        this.playerId = Objects.requireNonNull(playerId, "playerId cannot be null");
        this.totalCount = totalCount;
        this.unreadCount = unreadCount;
        this.lastActivity = lastActivity;
    }

    @NotNull
    public UUID getPlayerId() {
        return this.playerId;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getUnreadCount() {
        return this.unreadCount;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MailStats)) {
            return false;
        }
        MailStats that = (MailStats)obj;
        return this.totalCount == that.totalCount && this.unreadCount == that.unreadCount && this.lastActivity == that.lastActivity && this.playerId.equals(that.playerId);
    }

    public int hashCode() {
        return Objects.hash(this.playerId, this.totalCount, this.unreadCount, this.lastActivity);
    }

    public String toString() {
        return "MailStats{playerId=" + String.valueOf(this.playerId) + ", totalCount=" + this.totalCount + ", unreadCount=" + this.unreadCount + ", lastActivity=" + this.lastActivity + "}";
    }
}

