/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.mail;

import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MailInfo {
    @NotNull
    private final UUID senderId;
    @NotNull
    private final String senderName;
    @NotNull
    private final String message;
    private final long timestamp;
    @Nullable
    private final UUID targetId;
    private final boolean read;

    public MailInfo(@NotNull UUID senderId, @NotNull String senderName, @NotNull String message, long timestamp, @Nullable UUID targetId, boolean read) {
        this.senderId = Objects.requireNonNull(senderId, "senderId cannot be null");
        this.senderName = Objects.requireNonNull(senderName, "senderName cannot be null");
        this.message = Objects.requireNonNull(message, "message cannot be null");
        this.timestamp = timestamp;
        this.targetId = targetId;
        this.read = read;
    }

    @NotNull
    public UUID getSenderId() {
        return this.senderId;
    }

    @NotNull
    public String getSenderName() {
        return this.senderName;
    }

    @NotNull
    public String getMessage() {
        return this.message;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public UUID getTargetId() {
        return this.targetId;
    }

    public boolean isRead() {
        return this.read;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MailInfo)) {
            return false;
        }
        MailInfo that = (MailInfo)obj;
        return this.timestamp == that.timestamp && this.read == that.read && this.senderId.equals(that.senderId) && this.senderName.equals(that.senderName) && this.message.equals(that.message) && Objects.equals(this.targetId, that.targetId);
    }

    public int hashCode() {
        return Objects.hash(this.senderId, this.senderName, this.message, this.timestamp, this.targetId, this.read);
    }

    public String toString() {
        return "MailInfo{senderId=" + String.valueOf(this.senderId) + ", senderName='" + this.senderName + "', message='" + this.message + "', timestamp=" + this.timestamp + ", targetId=" + String.valueOf(this.targetId) + ", read=" + this.read + "}";
    }
}

