/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.lobby;

import java.util.Objects;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.jetbrains.annotations.NotNull;

public final class AnimationOptions {
    @NotNull
    private final String type;
    private final int duration;
    @NotNull
    private final Particle particle;
    @NotNull
    private final Sound sound;
    private final int particleCount;

    public AnimationOptions(@NotNull String type, int duration, @NotNull Particle particle, @NotNull Sound sound, int particleCount) {
        this.type = Objects.requireNonNull(type, "type cannot be null");
        this.duration = duration;
        this.particle = Objects.requireNonNull(particle, "particle cannot be null");
        this.sound = Objects.requireNonNull(sound, "sound cannot be null");
        this.particleCount = particleCount;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    public int getDuration() {
        return this.duration;
    }

    @NotNull
    public Particle getParticle() {
        return this.particle;
    }

    @NotNull
    public Sound getSound() {
        return this.sound;
    }

    public int getParticleCount() {
        return this.particleCount;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AnimationOptions)) {
            return false;
        }
        AnimationOptions that = (AnimationOptions)obj;
        return this.duration == that.duration && this.particleCount == that.particleCount && this.type.equals(that.type) && this.particle.equals((Object)that.particle) && this.sound.equals((Object)that.sound);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.duration, this.particle, this.sound, this.particleCount);
    }

    public String toString() {
        return "AnimationOptions{type='" + this.type + "', duration=" + this.duration + ", particle=" + String.valueOf(this.particle) + ", sound=" + String.valueOf(this.sound) + ", particleCount=" + this.particleCount + "}";
    }
}

