/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.kit;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KitItem {
    @NotNull
    private final String type;
    private final int amount;
    @Nullable
    private final String name;
    @Nullable
    private final List<String> lore;
    @Nullable
    private final Map<String, Integer> enchantments;

    public KitItem(@NotNull String type, int amount, @Nullable String name, @Nullable List<String> lore, @Nullable Map<String, Integer> enchantments) {
        this.type = Objects.requireNonNull(type, "type cannot be null");
        this.amount = amount;
        this.name = name;
        this.lore = lore;
        this.enchantments = enchantments;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    public int getAmount() {
        return this.amount;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public List<String> getLore() {
        return this.lore;
    }

    @Nullable
    public Map<String, Integer> getEnchantments() {
        return this.enchantments;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KitItem)) {
            return false;
        }
        KitItem that = (KitItem)obj;
        return this.amount == that.amount && this.type.equals(that.type) && Objects.equals(this.name, that.name) && Objects.equals(this.lore, that.lore) && Objects.equals(this.enchantments, that.enchantments);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.amount, this.name, this.lore, this.enchantments);
    }

    public String toString() {
        return "KitItem{type='" + this.type + "', amount=" + this.amount + ", name='" + this.name + "', lore=" + String.valueOf(this.lore) + ", enchantments=" + String.valueOf(this.enchantments) + "}";
    }
}

