/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.kit;

import com.serveressentials.api.kit.KitItem;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KitInfo {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @Nullable
    private final String permission;
    @NotNull
    private final String displayName;
    @NotNull
    private final String displayMaterial;
    @NotNull
    private final List<String> displayLore;
    private final int slot;
    private final int cooldown;
    @NotNull
    private final List<KitItem> items;

    public KitInfo(@NotNull String id, @NotNull String name, @Nullable String permission, @NotNull String displayName, @NotNull String displayMaterial, @NotNull List<String> displayLore, int slot, int cooldown, @NotNull List<KitItem> items) {
        this.id = Objects.requireNonNull(id, "id cannot be null");
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.permission = permission;
        this.displayName = Objects.requireNonNull(displayName, "displayName cannot be null");
        this.displayMaterial = Objects.requireNonNull(displayMaterial, "displayMaterial cannot be null");
        this.displayLore = Objects.requireNonNull(displayLore, "displayLore cannot be null");
        this.slot = slot;
        this.cooldown = cooldown;
        this.items = Objects.requireNonNull(items, "items cannot be null");
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getPermission() {
        return this.permission;
    }

    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public String getDisplayMaterial() {
        return this.displayMaterial;
    }

    @NotNull
    public List<String> getDisplayLore() {
        return this.displayLore;
    }

    public int getSlot() {
        return this.slot;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    @NotNull
    public List<KitItem> getItems() {
        return this.items;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KitInfo)) {
            return false;
        }
        KitInfo that = (KitInfo)obj;
        return this.slot == that.slot && this.cooldown == that.cooldown && this.id.equals(that.id) && this.name.equals(that.name) && Objects.equals(this.permission, that.permission) && this.displayName.equals(that.displayName) && this.displayMaterial.equals(that.displayMaterial) && this.displayLore.equals(that.displayLore) && this.items.equals(that.items);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.permission, this.displayName, this.displayMaterial, this.displayLore, this.slot, this.cooldown, this.items);
    }

    public String toString() {
        return "KitInfo{id='" + this.id + "', name='" + this.name + "', permission='" + this.permission + "', displayName='" + this.displayName + "', displayMaterial='" + this.displayMaterial + "', displayLore=" + String.valueOf(this.displayLore) + ", slot=" + this.slot + ", cooldown=" + this.cooldown + ", items=" + String.valueOf(this.items) + "}";
    }
}

