/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.economy;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class EconomyResponse {
    private final double amount;
    private final double balance;
    private final boolean success;
    @Nullable
    private final String errorMessage;

    public EconomyResponse(double amount, double balance, boolean success, @Nullable String errorMessage) {
        this.amount = amount;
        this.balance = balance;
        this.success = success;
        this.errorMessage = errorMessage;
    }

    public double getAmount() {
        return this.amount;
    }

    public double getBalance() {
        return this.balance;
    }

    public boolean isSuccess() {
        return this.success;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EconomyResponse)) {
            return false;
        }
        EconomyResponse that = (EconomyResponse)o;
        return Double.compare(that.amount, this.amount) == 0 && Double.compare(that.balance, this.balance) == 0 && this.success == that.success && Objects.equals(this.errorMessage, that.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.balance, this.success, this.errorMessage);
    }

    public String toString() {
        return this.success ? String.format("EconomyResponse{amount=%.2f, balance=%.2f, success=true}", this.amount, this.balance) : String.format("EconomyResponse{amount=%.2f, success=false, error='%s'}", this.amount, this.errorMessage);
    }
}

