/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.daily;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DailyRewardItem {
    @NotNull
    private final Material material;
    private final int amount;
    @Nullable
    private final String name;
    @NotNull
    private final List<String> lore;
    @NotNull
    private final Map<String, Integer> enchantments;
    private final boolean glow;
    @NotNull
    private final Map<String, String> nbt;

    public DailyRewardItem(@NotNull Material material, int amount, @Nullable String name, @NotNull List<String> lore, @NotNull Map<String, Integer> enchantments, boolean glow, @NotNull Map<String, String> nbt) {
        this.material = Objects.requireNonNull(material, "material cannot be null");
        this.amount = Math.max(1, amount);
        this.name = name;
        this.lore = Objects.requireNonNull(lore, "lore cannot be null");
        this.enchantments = Objects.requireNonNull(enchantments, "enchantments cannot be null");
        this.glow = glow;
        this.nbt = Objects.requireNonNull(nbt, "nbt cannot be null");
    }

    @NotNull
    public Material getMaterial() {
        return this.material;
    }

    public int getAmount() {
        return this.amount;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<String> getLore() {
        return List.copyOf(this.lore);
    }

    @NotNull
    public Map<String, Integer> getEnchantments() {
        return Map.copyOf(this.enchantments);
    }

    public boolean isGlow() {
        return this.glow;
    }

    @NotNull
    public Map<String, String> getNbt() {
        return Map.copyOf(this.nbt);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DailyRewardItem)) {
            return false;
        }
        DailyRewardItem that = (DailyRewardItem)o;
        return this.amount == that.amount && this.glow == that.glow && this.material.equals((Object)that.material) && Objects.equals(this.name, that.name) && this.lore.equals(that.lore) && this.enchantments.equals(that.enchantments) && this.nbt.equals(that.nbt);
    }

    public int hashCode() {
        return Objects.hash(this.material, this.amount, this.name, this.lore, this.enchantments, this.glow, this.nbt);
    }
}

