/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.daily;

import com.serveressentials.api.daily.DailyRewardItem;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class DailyReward {
    private final int day;
    private final int slot;
    private final int page;
    @NotNull
    private final List<DailyRewardItem> items;

    public DailyReward(int day, int slot, int page, @NotNull List<DailyRewardItem> items) {
        this.day = day;
        this.slot = slot;
        this.page = page;
        this.items = Objects.requireNonNull(items, "items cannot be null");
    }

    public int getDay() {
        return this.day;
    }

    public int getSlot() {
        return this.slot;
    }

    public int getPage() {
        return this.page;
    }

    @NotNull
    public List<DailyRewardItem> getItems() {
        return List.copyOf(this.items);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DailyReward that = (DailyReward)o;
        return this.day == that.day && this.slot == that.slot && this.page == that.page && this.items.equals(that.items);
    }

    public int hashCode() {
        return Objects.hash(this.day, this.slot, this.page, this.items);
    }

    public String toString() {
        return "DailyReward{day=" + this.day + ", slot=" + this.slot + ", page=" + this.page + ", items=" + String.valueOf(this.items) + "}";
    }
}

