/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.back.event;

import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class BackEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    @NotNull
    private final Player player;
    @NotNull
    private final BackType backType;

    public BackEvent(@NotNull Player player, @NotNull BackType backType) {
        super(!Bukkit.isPrimaryThread());
        this.player = Objects.requireNonNull(player, "player cannot be null");
        this.backType = Objects.requireNonNull(backType, "backType cannot be null");
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public BackType getBackType() {
        return this.backType;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static enum BackType {
        BACK_LOCATION,
        LOBBY,
        DEATH_LOCATION;

    }
}

