/*
 * Decompiled with CFR 0.152.
 */
package com.serveressentials.api.back;

import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BackLocationData {
    @NotNull
    private final String worldName;
    private final double x;
    private final double y;
    private final double z;
    private final float yaw;
    private final float pitch;
    private final long timestamp;

    public BackLocationData(@NotNull String worldName, double x, double y, double z, float yaw, float pitch, long timestamp) {
        this.worldName = Objects.requireNonNull(worldName, "worldName cannot be null");
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.timestamp = timestamp;
    }

    public BackLocationData(@NotNull Location location) {
        this(Objects.requireNonNull(location.getWorld(), "World cannot be null").getName(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch(), System.currentTimeMillis());
    }

    @NotNull
    public String getWorldName() {
        return this.worldName;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public Location toLocation() {
        World world = Bukkit.getWorld((String)this.worldName);
        return world != null ? new Location(world, this.x, this.y, this.z, this.yaw, this.pitch) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackLocationData)) {
            return false;
        }
        BackLocationData that = (BackLocationData)o;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0 && Double.compare(that.z, this.z) == 0 && Float.compare(that.yaw, this.yaw) == 0 && Float.compare(that.pitch, this.pitch) == 0 && this.timestamp == that.timestamp && this.worldName.equals(that.worldName);
    }

    public int hashCode() {
        return Objects.hash(this.worldName, this.x, this.y, this.z, Float.valueOf(this.yaw), Float.valueOf(this.pitch), this.timestamp);
    }

    public String toString() {
        return "BackLocationData{worldName='" + this.worldName + "', x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", yaw=" + this.yaw + ", pitch=" + this.pitch + ", timestamp=" + this.timestamp + "}";
    }
}

