/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.warp;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.ServerEssentials;
import net.lunark.io.util.WarpMessages;
import net.lunark.io.warp.WarpManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WarpsCommand
implements CommandExecutor {
    private final ServerEssentials plugin;
    private final WarpManager warpManager;
    private final WarpMessages messages;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public WarpsCommand(ServerEssentials plugin) {
        this.plugin = plugin;
        this.warpManager = plugin.getWarpManager();
        this.messages = plugin.getWarpMessages();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("serveressentials.warps")) {
            player.sendMessage(this.messages.get("no-permission", new String[0]));
            return true;
        }
        if (this.warpManager.getWarps().isEmpty()) {
            player.sendMessage(this.messages.get("warp-list-empty", new String[0]));
            return true;
        }
        player.sendMessage(this.messages.get("warp-list-header", new String[0]));
        this.warpManager.getWarps().keySet().forEach(warp -> {
            Component line = this.messages.get("warp-list-entry", "<warp>", (String)warp);
            player.sendMessage(line);
        });
        return true;
    }
}

