/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.util;

import java.io.File;
import java.io.IOException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.ServerEssentials;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class VaultMessages {
    private static VaultMessages instance;
    private final ServerEssentials plugin;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private FileConfiguration config;
    private File file;

    public VaultMessages(ServerEssentials plugin) {
        this.plugin = plugin;
        instance = this;
        this.load();
    }

    public static VaultMessages getInstance() {
        return instance;
    }

    private void load() {
        this.file = new File(this.plugin.getDataFolder(), "messages/vault.yml");
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        if (!this.file.exists()) {
            this.plugin.saveResource("messages/vault.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void reload() {
        this.load();
        this.plugin.getLogger().info("[VaultMessages] Reloaded messages/vault.yml successfully.");
    }

    public static void fullReload() {
        if (instance != null) {
            instance.reload();
        }
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save messages/vault.yml!");
            e.printStackTrace();
        }
    }

    public void addDefault(String path, String defaultMessage) {
        if (!this.config.contains(path)) {
            this.config.set(path, (Object)defaultMessage);
            this.save();
        }
    }

    public Component get(String path, String ... placeholders) {
        String msg = this.config.getString(path, "<red>Missing message for " + path);
        if (placeholders != null && placeholders.length % 2 == 0) {
            for (int i = 0; i < placeholders.length; i += 2) {
                msg = msg.replace(placeholders[i], placeholders[i + 1]);
            }
        }
        return this.miniMessage.deserialize(msg);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

