/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.staff;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.lunark.io.ServerEssentials;
import net.lunark.io.util.MessagesManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FlyCommand
implements CommandExecutor {
    private final MessagesManager messages;

    public FlyCommand(ServerEssentials plugin) {
        this.messages = new MessagesManager(plugin);
        this.messages.addDefault("fly.only-players", "<red>Only players can use this command.");
        this.messages.addDefault("fly.enabled", "<blue>Flight <green>enabled<blue>.");
        this.messages.addDefault("fly.disabled", "<blue>Flight <red>disabled<blue>.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, "fly.only-players");
            return true;
        }
        Player player = (Player)sender;
        boolean flying = player.getAllowFlight();
        player.setAllowFlight(!flying);
        player.setFlying(!flying);
        if (flying) {
            this.sendMessage((CommandSender)player, "fly.disabled");
        } else {
            this.sendMessage((CommandSender)player, "fly.enabled");
        }
        return true;
    }

    private void sendMessage(CommandSender sender, String path) {
        Component message = this.messages.getMessageComponent(path, new String[0]);
        if (sender instanceof Player) {
            Player p = (Player)sender;
            p.sendMessage(message);
        } else {
            sender.sendMessage(LegacyComponentSerializer.legacyAmpersand().serialize(message));
        }
    }
}

