/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.staff;

import java.util.HashSet;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.ServerEssentials;
import net.lunark.io.staff.AdminChatUtils;
import net.lunark.io.util.MessagesManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminChatCommand
implements CommandExecutor {
    private static final Set<Player> toggled = new HashSet<Player>();
    private static final MiniMessage miniMessage = MiniMessage.miniMessage();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        MessagesManager messages = ServerEssentials.getInstance().getMessagesManager();
        if (!(sender instanceof Player)) {
            sender.sendMessage(messages.getMessageComponent("adminchat.only-players", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("serveressentials.adminchat")) {
            player.sendMessage(messages.getMessageComponent("adminchat.no-permission", new String[0]));
            return true;
        }
        if (args.length == 0) {
            boolean isNowToggled;
            if (toggled.contains(player)) {
                toggled.remove(player);
                isNowToggled = false;
            } else {
                toggled.add(player);
                isNowToggled = true;
            }
            Component toggleMessage = messages.getMessageComponent("adminchat.toggle", "%state%", isNowToggled ? "ON" : "OFF");
            player.sendMessage(toggleMessage);
        } else {
            String message = String.join((CharSequence)" ", args);
            AdminChatUtils.sendAdminMessage(player, message);
        }
        return true;
    }

    public static boolean isInAdminChat(Player player) {
        return toggled.contains(player);
    }
}

