/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.serverEssentials;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.lunark.io.Managers.ReloadManager;
import net.lunark.io.ServerEssentials;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerEssentialsCommand
implements CommandExecutor,
TabCompleter {
    private final Plugin plugin;
    private final Map<String, Consumer<CommandSender>> subCommands = new LinkedHashMap<String, Consumer<CommandSender>>();
    private final String PREFIX = ServerEssentialsCommand.gradient("#00BFFF", "#00FFFF", "ServerEssentials") + " \u00a78\u00bb \u00a7r";

    public ServerEssentialsCommand(Plugin plugin) {
        this.plugin = plugin;
        this.subCommands.put("help", this::sendHelp);
        this.subCommands.put("info", this::showInfo);
        this.subCommands.put("version", this::showVersion);
        this.subCommands.put("reload", this::reloadPlugin);
        this.subCommands.put("discord", this::sendDiscord);
        this.subCommands.put("website", this::sendWebsite);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        String sub = args[0].toLowerCase();
        Consumer<CommandSender> action = this.subCommands.get(sub);
        if (action == null) {
            this.sendMessage(sender, "#FF5555", "Unknown subcommand. Use /" + label + " help");
            return true;
        }
        action.accept(sender);
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            return this.subCommands.keySet().stream().filter(s -> s.startsWith(input)).sorted().toList();
        }
        return Collections.emptyList();
    }

    private void sendHelp(CommandSender sender) {
        this.sendTitle(sender, "ServerEssentials Command Center");
        this.sendMessage(sender, "#00FFFF", "\u2699 /se info - About this plugin");
        this.sendMessage(sender, "#00FFFF", "\ud83e\udde9 /se version - Check current & latest version");
        this.sendMessage(sender, "#00FFFF", "\ud83d\udd01 /se reload - Reload all systems");
        this.sendMessage(sender, "#00FFFF", "\ud83d\udcac /se discord - Get our Discord link");
        this.sendMessage(sender, "#00FFFF", "\ud83c\udf10 /se website - Visit our official site");
    }

    private void showInfo(CommandSender sender) {
        this.sendTitle(sender, "ServerEssentials");
        this.sendMessage(sender, "#00FFFF", "\ud83d\udc8e A premium, modern all-in-one server plugin.");
        this.sendMessage(sender, "#AAAAAA", String.join((CharSequence)("\n" + this.PREFIX + ServerEssentialsCommand.color("#AAAAAA")), "\u2022 RTP & Home Systems", "\u2022 Auction House & Shops", "\u2022 Warp, Rank & Coinflip Modules", "\u2022 Fully Customizable Scoreboards", "\u2022 Admin Tools & GUI Systems", "\u2022 Join/Leave, Chat, and More"));
        this.sendMessage(sender, "#00E5FF", "Built for performance. Designed with passion. \u26a1");
    }

    private void sendDiscord(CommandSender sender) {
        this.sendTitle(sender, "ServerEssentials Discord");
        this.sendMessage(sender, "#00BFFF", "\ud83d\udcac Join our community: " + ServerEssentialsCommand.color("#FFFFFF") + "https://discord.gg/WJdxucXE");
    }

    private void sendWebsite(CommandSender sender) {
        this.sendTitle(sender, "ServerEssentials Website");
        this.sendMessage(sender, "#00BFFF", "\ud83c\udf10 Visit us: " + ServerEssentialsCommand.color("#FFFFFF") + "https://serveressentials.parrotstudio.dev");
    }

    private void showVersion(CommandSender sender) {
        String currentVersion = this.plugin.getDescription().getVersion();
        this.sendTitle(sender, "Version Checker");
        this.sendMessage(sender, "#00E5FF", "Current Version: " + ServerEssentialsCommand.color("#FFFFFF") + currentVersion);
        this.sendMessage(sender, "#AAAAAA", "Checking for updates...");
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            String latest = this.getLatestVersionFromModrinth();
            Bukkit.getScheduler().runTask(this.plugin, () -> {
                if (latest == null) {
                    this.sendMessage(sender, "#FF5555", "\u274c Could not fetch the latest version.");
                    return;
                }
                this.sendMessage(sender, "#FFD700", "Latest Version: " + ServerEssentialsCommand.color("#FFFFFF") + latest);
                if (!latest.equalsIgnoreCase(currentVersion)) {
                    this.sendMessage(sender, "#FF5555", "\u26a0 You are using an outdated version. Please update!");
                } else {
                    this.sendMessage(sender, "#55FF55", "\u2705 You are fully up-to-date!");
                }
            });
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getLatestVersionFromModrinth() {
        try {
            URL url = new URL("https://api.modrinth.com/v2/project/serveressentials/version");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(4000);
            conn.setReadTimeout(4000);
            if (conn.getResponseCode() != 200) {
                return null;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                String response = reader.lines().reduce("", (a, b) -> a + b);
                int idx = response.indexOf("\"version_number\":");
                if (idx == -1) return null;
                int start = response.indexOf(34, idx + 17) + 1;
                int end = response.indexOf(34, start);
                String string = response.substring(start, end);
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void reloadPlugin(CommandSender sender) {
        if (!(this.plugin instanceof ServerEssentials)) {
            this.sendMessage(sender, "#FF5555", "Reload failed: plugin instance mismatch.");
            return;
        }
        this.sendTitle(sender, "\u2699 Reloading System Components...");
        String[] sequence = new String[]{ServerEssentialsCommand.color("#00BFFF") + "[\u25a0\u25a1\u25a1\u25a1\u25a1\u25a1\u25a1\u25a1\u25a1\u25a1] " + ServerEssentialsCommand.color("#AAAAAA") + "Initializing core...", ServerEssentialsCommand.color("#00CFFF") + "[\u25a0\u25a0\u25a1\u25a1\u25a1\u25a1\u25a1\u25a1\u25a1\u25a1] " + ServerEssentialsCommand.color("#AAAAAA") + "Loading modules...", ServerEssentialsCommand.color("#00DFFF") + "[\u25a0\u25a0\u25a0\u25a1\u25a1\u25a1\u25a1\u25a1\u25a1\u25a1] " + ServerEssentialsCommand.color("#AAAAAA") + "Reloading configs...", ServerEssentialsCommand.color("#00EFFF") + "[\u25a0\u25a0\u25a0\u25a0\u25a1\u25a1\u25a1\u25a1\u25a1\u25a1] " + ServerEssentialsCommand.color("#AAAAAA") + "Updating cache...", ServerEssentialsCommand.color("#00FFFF") + "[\u25a0\u25a0\u25a0\u25a0\u25a0\u25a1\u25a1\u25a1\u25a1\u25a1] " + ServerEssentialsCommand.color("#AAAAAA") + "Refreshing UI...", ServerEssentialsCommand.color("#40FFFF") + "[\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a1\u25a1\u25a1\u25a1] " + ServerEssentialsCommand.color("#AAAAAA") + "Syncing APIs...", ServerEssentialsCommand.color("#80FFFF") + "[\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a1\u25a1\u25a1] " + ServerEssentialsCommand.color("#AAAAAA") + "Reinitializing data...", ServerEssentialsCommand.color("#B0FFFF") + "[\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a1\u25a1] " + ServerEssentialsCommand.color("#AAAAAA") + "Final checks...", ServerEssentialsCommand.color("#E0FFFF") + "[\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a1] " + ServerEssentialsCommand.color("#AAAAAA") + "Polishing systems...", ServerEssentialsCommand.color("#FFFFFF") + "[\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0] " + ServerEssentialsCommand.gradient("#00BFFF", "#00FFFF", "Reload Complete!") + " \u26a1"};
        for (int i = 0; i < sequence.length; ++i) {
            int delay = i * 10;
            String msg = sequence[i];
            Bukkit.getScheduler().runTaskLater(this.plugin, () -> sender.sendMessage(this.PREFIX + msg), (long)delay);
        }
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
            try {
                ReloadManager.reloadAll(sender);
            }
            catch (Exception e) {
                this.sendMessage(sender, "#FF5555", "\u274c An error occurred during reload.");
                e.printStackTrace();
            }
        }, 40L);
    }

    private void sendTitle(CommandSender sender, String title) {
        sender.sendMessage("");
        sender.sendMessage(this.PREFIX + ServerEssentialsCommand.gradient("#00BFFF", "#00FFFF", "\u2501\u2501\u2501 " + title + " \u2501\u2501\u2501"));
        sender.sendMessage("");
    }

    private void sendMessage(CommandSender sender, String hexColor, String message) {
        sender.sendMessage(this.PREFIX + ServerEssentialsCommand.color(hexColor) + message);
    }

    private static String color(String hexColor) {
        if ((hexColor = hexColor.replace("#", "")).length() != 6) {
            return "\u00a7f";
        }
        StringBuilder sb = new StringBuilder("\u00a7x");
        for (char c : hexColor.toCharArray()) {
            sb.append("\u00a7").append(c);
        }
        return sb.toString();
    }

    private static String gradient(String startHex, String endHex, String text) {
        startHex = startHex.replace("#", "");
        endHex = endHex.replace("#", "");
        if (startHex.length() != 6 || endHex.length() != 6) {
            return text;
        }
        int[] start = new int[]{Integer.parseInt(startHex.substring(0, 2), 16), Integer.parseInt(startHex.substring(2, 4), 16), Integer.parseInt(startHex.substring(4, 6), 16)};
        int[] end = new int[]{Integer.parseInt(endHex.substring(0, 2), 16), Integer.parseInt(endHex.substring(2, 4), 16), Integer.parseInt(endHex.substring(4, 6), 16)};
        StringBuilder gradient = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            double ratio = (double)i / (double)Math.max(1, text.length() - 1);
            int r = (int)((double)start[0] + ratio * (double)(end[0] - start[0]));
            int g = (int)((double)start[1] + ratio * (double)(end[1] - start[1]));
            int b = (int)((double)start[2] + ratio * (double)(end[2] - start[2]));
            String hex = String.format("%02x%02x%02x", r, g, b);
            gradient.append("\u00a7x");
            for (char c : hex.toCharArray()) {
                gradient.append("\u00a7").append(c);
            }
            gradient.append(text.charAt(i));
        }
        return gradient.toString();
    }
}

