/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.server;

import net.kyori.adventure.text.Component;
import net.lunark.io.util.ServerMessages;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class UptimeCommand
implements CommandExecutor {
    private final long serverStartTime;
    private final ServerMessages messages;

    public UptimeCommand(long serverStartTime, ServerMessages messages) {
        this.serverStartTime = serverStartTime;
        this.messages = messages;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        long currentTime = System.currentTimeMillis();
        long uptimeMillis = currentTime - this.serverStartTime;
        long seconds = uptimeMillis / 1000L % 60L;
        long minutes = uptimeMillis / 60000L % 60L;
        long hours = uptimeMillis / 3600000L % 24L;
        long days = uptimeMillis / 86400000L;
        String uptimeStr = String.format("%d days, %d hours, %d minutes, %d seconds", days, hours, minutes, seconds);
        Component msg = this.messages.get("uptime.info", "<uptime>", uptimeStr);
        sender.sendMessage(msg);
        return true;
    }
}

