/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.lunark.io.util.ServerMessages;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class UnloadWorldCommand
implements CommandExecutor,
TabCompleter {
    private final ServerMessages messages;

    public UnloadWorldCommand(ServerMessages messages) {
        this.messages = messages;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length != 1) {
            sender.sendMessage(this.messages.get("unloadworld.usage"));
            return true;
        }
        String worldName = args[0];
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            Component msg = this.messages.get("unloadworld.not-found", "<world>", worldName);
            sender.sendMessage(msg);
            return true;
        }
        if (!Bukkit.unloadWorld((World)world, (boolean)true)) {
            Component msg = this.messages.get("unloadworld.failed", "<world>", worldName);
            sender.sendMessage(msg);
            return true;
        }
        Component msg = this.messages.get("unloadworld.success", "<world>", worldName);
        sender.sendMessage(msg);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> worldNames = new ArrayList<String>();
            for (World world : Bukkit.getWorlds()) {
                worldNames.add(world.getName());
            }
            String input = args[0].toLowerCase();
            worldNames.removeIf(name -> !name.toLowerCase().startsWith(input));
            return worldNames;
        }
        return Collections.emptyList();
    }
}

