/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.server;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.List;
import net.lunark.io.util.ServerMessages;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ServerInfoCommand
implements CommandExecutor {
    private final ServerMessages messages;
    private final DecimalFormat df = new DecimalFormat("#.##");

    public ServerInfoCommand(ServerMessages messages) {
        this.messages = messages;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("ServerInfo.only-players"));
            return true;
        }
        Player player = (Player)sender;
        long maxMemory = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        long totalMemory = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
        long freeMemory = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
        long usedMemory = totalMemory - freeMemory;
        File root = new File(".");
        long freeDiskMB = root.getFreeSpace() / 1024L / 1024L;
        long totalDiskMB = root.getTotalSpace() / 1024L / 1024L;
        double tps = Bukkit.getTPS()[0];
        java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        int cpuCores = osBean.getAvailableProcessors();
        Object cpuLoadStr = "N/A";
        try {
            OperatingSystemMXBean sunOsBean = (OperatingSystemMXBean)osBean;
            double load = sunOsBean.getSystemCpuLoad();
            if (load >= 0.0) {
                cpuLoadStr = this.df.format(load * 100.0) + "%";
            }
        }
        catch (ClassCastException sunOsBean) {
            // empty catch block
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        long uptimeMillis = runtimeMXBean.getUptime();
        long uptimeSeconds = uptimeMillis / 1000L;
        long uptimeMinutes = uptimeSeconds / 60L;
        long uptimeHours = uptimeMinutes / 60L;
        List<String> jvmArgs = runtimeMXBean.getInputArguments();
        String hostname = "Unknown";
        String hostAddress = "Unknown";
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            hostname = localHost.getHostName();
            hostAddress = localHost.getHostAddress();
        }
        catch (UnknownHostException localHost) {
            // empty catch block
        }
        StringBuilder netInterfaces = new StringBuilder();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            while (nets.hasMoreElements()) {
                NetworkInterface netIf = nets.nextElement();
                if (!netIf.isUp() || netIf.isLoopback()) continue;
                Enumeration<InetAddress> addresses = netIf.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (addr.isLoopbackAddress()) continue;
                    netInterfaces.append(netIf.getDisplayName()).append(": ").append(addr.getHostAddress()).append(", ");
                }
            }
        }
        catch (SocketException nets) {
            // empty catch block
        }
        int pluginCount = Bukkit.getPluginManager().getPlugins().length;
        int onlinePlayers = Bukkit.getOnlinePlayers().size();
        int maxPlayers = Bukkit.getMaxPlayers();
        String minecraftVersion = Bukkit.getVersion();
        String paperVersion = Bukkit.getName() + " " + Bukkit.getBukkitVersion();
        String gpuInfo = "Not Available";
        player.sendMessage(this.messages.get("ServerInfo.header"));
        player.sendMessage(this.messages.get("ServerInfo.ram", "{used}", String.valueOf(usedMemory), "{max}", String.valueOf(maxMemory)));
        player.sendMessage(this.messages.get("ServerInfo.disk", "{free}", String.valueOf(freeDiskMB), "{total}", String.valueOf(totalDiskMB)));
        player.sendMessage(this.messages.get("ServerInfo.tps", "{tps}", this.df.format(tps)));
        player.sendMessage(this.messages.get("ServerInfo.cpu", new String[]{"{cores}", String.valueOf(cpuCores), "{load}", cpuLoadStr}));
        player.sendMessage(this.messages.get("ServerInfo.os", "{name}", osName, "{version}", osVersion, "{arch}", osArch));
        player.sendMessage(this.messages.get("ServerInfo.uptime", "{hours}", String.valueOf(uptimeHours), "{minutes}", String.valueOf(uptimeMinutes % 60L), "{seconds}", String.valueOf(uptimeSeconds % 60L)));
        player.sendMessage(this.messages.get("ServerInfo.java", "{version}", System.getProperty("java.version")));
        player.sendMessage(this.messages.get("ServerInfo.host", "{hostname}", hostname, "{address}", hostAddress));
        player.sendMessage(this.messages.get("ServerInfo.net", "{interfaces}", netInterfaces.length() > 0 ? netInterfaces.substring(0, netInterfaces.length() - 2) : "None"));
        player.sendMessage(this.messages.get("ServerInfo.plugins", "{count}", String.valueOf(pluginCount)));
        player.sendMessage(this.messages.get("ServerInfo.minecraft", "{version}", minecraftVersion));
        player.sendMessage(this.messages.get("ServerInfo.paper", "{version}", paperVersion));
        player.sendMessage(this.messages.get("ServerInfo.players", "{online}", String.valueOf(onlinePlayers), "{max}", String.valueOf(maxPlayers)));
        player.sendMessage(this.messages.get("ServerInfo.gpu", "{gpu}", gpuInfo));
        player.sendMessage(this.messages.get("ServerInfo.jvm", "{args}", String.join((CharSequence)", ", jvmArgs)));
        return true;
    }
}

