/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.server;

import java.io.File;
import java.util.List;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.ServerEssentials;
import net.lunark.io.util.ServerMessages;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class MotdCommand
implements CommandExecutor {
    private final ServerMessages serverMessages;
    private final File motdFile;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private static final int CHAT_LINE_WIDTH = 60;

    public MotdCommand(ServerEssentials plugin) {
        this.serverMessages = new ServerMessages((Plugin)plugin, "messages/server.yml");
        this.motdFile = new File(plugin.getDataFolder(), "motd.yml");
        this.serverMessages.addDefault("motd.reload-success", "<green>MOTD reloaded from motd.yml and will be shown on ping.");
        this.serverMessages.addDefault("motd.file-created", "<yellow>Default motd.yml created.");
        this.serverMessages.addDefault("motd.file-missing", "<red>Error: motd.yml is missing from both plugin folder and JAR resources.");
        this.serverMessages.addDefault("motd.file-empty", "<red>Your motd.yml is empty or malformed.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.motdFile.exists()) {
            sender.sendMessage(this.serverMessages.get("motd.file-created"));
            return true;
        }
        List lines = this.serverMessages.getConfig().getStringList("motd");
        if (lines == null || lines.isEmpty()) {
            sender.sendMessage(this.serverMessages.get("motd.file-empty"));
            return true;
        }
        for (Object line : lines) {
            int spaces;
            boolean centered = false;
            if (((String)line).startsWith("[centered]")) {
                centered = true;
                line = ((String)line).replaceFirst("\\[centered\\]", "");
            }
            line = ((String)line).replace("{player}", sender.getName());
            if (centered && (spaces = (60 - ((String)line).length()) / 2) > 0) {
                String padding = " ".repeat(spaces);
                line = padding + (String)line;
            }
            Object message = this.miniMessage.deserialize(line);
            sender.sendMessage(message);
        }
        sender.sendMessage(this.serverMessages.get("motd.reload-success"));
        return true;
    }
}

