/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.server;

import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.util.ServerMessages;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class BroadcastWorldCommand
implements CommandExecutor {
    private final ServerMessages messages;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public BroadcastWorldCommand(ServerMessages messages) {
        this.messages = messages;
        messages.addDefault("BroadcastWorld.Usage", "Usage: /broadcastworld <world> <message>");
        messages.addDefault("BroadcastWorld.WorldNotFound", "World '{world}' not found!");
        messages.addDefault("BroadcastWorld.MessageSent", "Message broadcasted to world '{world}'!");
        messages.addDefault("BroadcastWorld.Broadcast", "{message}");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 2) {
            Object usage = this.miniMessage.deserialize(this.messages.getConfig().getString("BroadcastWorld.Usage"));
            sender.sendMessage(usage);
            return true;
        }
        World world = Bukkit.getWorld((String)args[0]);
        if (world == null) {
            Object notFound = this.miniMessage.deserialize(this.messages.getConfig().getString("BroadcastWorld.WorldNotFound").replace("{world}", args[0]));
            sender.sendMessage(notFound);
            return true;
        }
        StringBuilder rawMessage = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            rawMessage.append(args[i]).append(" ");
        }
        Object broadcast = this.miniMessage.deserialize(this.messages.getConfig().getString("BroadcastWorld.Broadcast").replace("{message}", rawMessage.toString().trim()));
        world.getPlayers().forEach(p -> p.sendMessage(broadcast));
        String confirmationRaw = this.messages.getConfig().getString("BroadcastWorld.MessageSent").replace("{world}", world.getName());
        sender.sendMessage(this.miniMessage.deserialize(confirmationRaw));
        return true;
    }
}

