/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.scoreboard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.lunark.io.scoreboard.CustomScoreboardManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class ScoreboardCommand
implements CommandExecutor,
TabCompleter {
    private final CustomScoreboardManager manager;

    public ScoreboardCommand(CustomScoreboardManager manager) {
        this.manager = manager;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command is only for players.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.manager.getMessages().send(player, "commands.help", new String[0]);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("scoreboard.reload")) {
                    this.manager.getMessages().send(player, "commands.no-permission", new String[0]);
                    return true;
                }
                this.manager.reload();
                this.manager.getMessages().send(player, "commands.reload.success", new String[0]);
                for (Player p : player.getServer().getOnlinePlayers()) {
                    String layout = this.manager.getConfigHandler().getLayoutForPlayer(p, this.manager.getStorage());
                    if (this.manager.getStorage().isEnabled(p)) {
                        this.manager.getUpdater().update(p, layout);
                        continue;
                    }
                    this.manager.getUpdater().clear(p);
                }
                break;
            }
            case "toggle": {
                boolean state = this.manager.getStorage().togglePlayer(player);
                if (state) {
                    this.manager.getMessages().send(player, "commands.toggle.enabled", new String[0]);
                    this.manager.getUpdater().update(player);
                    break;
                }
                this.manager.getMessages().send(player, "commands.toggle.disabled", new String[0]);
                this.manager.getUpdater().clear(player);
                break;
            }
            case "color": {
                if (args.length < 2) {
                    this.manager.getMessages().send(player, "commands.color.usage", new String[0]);
                    return true;
                }
                String newLayout = args[1].toLowerCase();
                if (!this.manager.getConfigHandler().layoutExists(newLayout)) {
                    this.manager.getMessages().send(player, "commands.color.not-found", new String[0]);
                    return true;
                }
                this.manager.getStorage().setPlayerLayout(player, newLayout);
                this.manager.getUpdater().update(player, newLayout);
                this.manager.getMessages().send(player, "commands.color.changed", "<layout>", newLayout);
                break;
            }
            default: {
                this.manager.getMessages().send(player, "commands.help", new String[0]);
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            ArrayList<String> options = new ArrayList<String>();
            options.add("reload");
            options.add("toggle");
            options.add("color");
            String arg = args[0].toLowerCase();
            options.removeIf(s -> !s.startsWith(arg));
            return options;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("color")) {
            List<String> layouts = this.manager.getConfigHandler().getLayouts();
            String arg = args[1].toLowerCase();
            layouts.removeIf(s -> !s.toLowerCase().startsWith(arg));
            return layouts;
        }
        return Collections.emptyList();
    }
}

