/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.scoreboard;

import net.lunark.io.scoreboard.ScoreboardCommand;
import net.lunark.io.scoreboard.ScoreboardConfig;
import net.lunark.io.scoreboard.ScoreboardDatabase;
import net.lunark.io.scoreboard.ScoreboardListener;
import net.lunark.io.scoreboard.ScoreboardStorage;
import net.lunark.io.scoreboard.ScoreboardUpdater;
import net.lunark.io.scoreboard.util.MessageUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CustomScoreboardManager {
    private static CustomScoreboardManager instance;
    private final JavaPlugin plugin;
    private final ScoreboardConfig configHandler;
    private final ScoreboardStorage storage;
    private final ScoreboardDatabase database;
    private final ScoreboardUpdater updater;
    private final MessageUtil messages;

    public CustomScoreboardManager(JavaPlugin plugin) {
        instance = this;
        this.plugin = plugin;
        this.messages = new MessageUtil(plugin, "messages/scoreboard_system.yml");
        this.configHandler = new ScoreboardConfig(plugin);
        this.storage = new ScoreboardStorage(plugin);
        this.database = new ScoreboardDatabase(plugin);
        this.updater = new ScoreboardUpdater(this);
        plugin.getCommand("scoreboard").setExecutor((CommandExecutor)new ScoreboardCommand(this));
        Bukkit.getPluginManager().registerEvents((Listener)new ScoreboardListener(this), (Plugin)plugin);
        this.updater.start();
    }

    public static CustomScoreboardManager getInstance() {
        return instance;
    }

    public static void reloadAll() {
        if (instance == null) {
            return;
        }
        CustomScoreboardManager.instance.configHandler.reload();
        CustomScoreboardManager.instance.storage.reload();
        CustomScoreboardManager.instance.messages.reload();
        CustomScoreboardManager.instance.updater.refreshAll();
        CustomScoreboardManager.instance.plugin.getLogger().info("[Scoreboard] Fully reloaded configuration and refreshed all player scoreboards.");
    }

    public void reload() {
        CustomScoreboardManager.reloadAll();
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public ScoreboardConfig getConfigHandler() {
        return this.configHandler;
    }

    public ScoreboardStorage getStorage() {
        return this.storage;
    }

    public ScoreboardDatabase getDatabase() {
        return this.database;
    }

    public ScoreboardUpdater getUpdater() {
        return this.updater;
    }

    public MessageUtil getMessages() {
        return this.messages;
    }
}

