/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.pw;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.lunark.io.config.GUIConfig;
import net.lunark.io.pw.PlayerWarp;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class WarpStorage {
    private final Map<UUID, List<PlayerWarp>> warpMap = new HashMap<UUID, List<PlayerWarp>>();
    private final Map<UUID, PlayerWarp> editing = new HashMap<UUID, PlayerWarp>();
    private final GUIConfig guiConfig;
    private final File file;
    private FileConfiguration config;
    public static final List<String> HARDCODED_CATEGORIES = List.of("Shop", "Server", "Misc", "Builds", "Towns", "Redstone");

    public WarpStorage(JavaPlugin plugin, GUIConfig guiConfig) {
        this.guiConfig = guiConfig;
        File storageFolder = new File(plugin.getDataFolder(), "storage");
        if (!storageFolder.exists()) {
            storageFolder.mkdirs();
        }
        this.file = new File(storageFolder, "pw.yml");
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                plugin.getLogger().severe("Failed to create storage/pw.yml!");
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void loadAll() {
        this.warpMap.clear();
        if (!this.config.contains("warps")) {
            return;
        }
        for (String uuidStr : this.config.getConfigurationSection("warps").getKeys(false)) {
            UUID owner = UUID.fromString(uuidStr);
            ArrayList<PlayerWarp> playerWarps = new ArrayList<PlayerWarp>();
            for (String warpName : this.config.getConfigurationSection("warps." + uuidStr).getKeys(false)) {
                String basePath = "warps." + uuidStr + "." + warpName;
                String worldName = this.config.getString(basePath + ".world");
                World world = Bukkit.getWorld((String)worldName);
                if (world == null) {
                    Bukkit.getLogger().warning("Warp '" + warpName + "' skipped: world '" + worldName + "' does not exist.");
                    continue;
                }
                double x = this.config.getDouble(basePath + ".x");
                double y = this.config.getDouble(basePath + ".y");
                double z = this.config.getDouble(basePath + ".z");
                float yaw = (float)this.config.getDouble(basePath + ".yaw");
                float pitch = (float)this.config.getDouble(basePath + ".pitch");
                String category = this.config.getString(basePath + ".category", "Misc");
                Location loc = new Location(world, x, y, z, yaw, pitch);
                playerWarps.add(new PlayerWarp(owner, warpName, loc, category));
            }
            this.warpMap.put(owner, playerWarps);
        }
    }

    public void saveAll() {
        this.config.set("warps", null);
        for (UUID owner : this.warpMap.keySet()) {
            for (PlayerWarp warp : this.warpMap.get(owner)) {
                String basePath = "warps." + owner.toString() + "." + warp.getName();
                Location loc = warp.getLocation();
                this.config.set(basePath + ".world", (Object)loc.getWorld().getName());
                this.config.set(basePath + ".x", (Object)loc.getX());
                this.config.set(basePath + ".y", (Object)loc.getY());
                this.config.set(basePath + ".z", (Object)loc.getZ());
                this.config.set(basePath + ".yaw", (Object)Float.valueOf(loc.getYaw()));
                this.config.set(basePath + ".pitch", (Object)Float.valueOf(loc.getPitch()));
                this.config.set(basePath + ".category", (Object)warp.getCategory());
            }
        }
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            Bukkit.getLogger().severe("Failed to save pw.yml!");
            e.printStackTrace();
        }
    }

    public void addWarp(PlayerWarp warp) {
        this.warpMap.computeIfAbsent(warp.getOwner(), k -> new ArrayList()).add(warp);
        this.saveAll();
    }

    public List<PlayerWarp> getWarps(UUID playerId) {
        return this.warpMap.getOrDefault(playerId, new ArrayList());
    }

    public List<String> getCategories(UUID player) {
        return this.guiConfig.getCategories();
    }

    public void setEditingWarp(Player player, PlayerWarp warp) {
        this.editing.put(player.getUniqueId(), warp);
    }

    public PlayerWarp getEditingWarp(Player player) {
        return this.editing.get(player.getUniqueId());
    }

    public void clearEditingWarp(Player player) {
        this.editing.remove(player.getUniqueId());
    }

    public List<PlayerWarp> getWarpsInCategory(String category) {
        ArrayList<PlayerWarp> result = new ArrayList<PlayerWarp>();
        for (List<PlayerWarp> warps : this.warpMap.values()) {
            for (PlayerWarp warp : warps) {
                if (!warp.getCategory().equalsIgnoreCase(category)) continue;
                result.add(warp);
            }
        }
        return result;
    }

    public PlayerWarp getWarp(String warpName) {
        for (List<PlayerWarp> warps : this.warpMap.values()) {
            for (PlayerWarp warp : warps) {
                if (!warp.getName().equalsIgnoreCase(warpName)) continue;
                return warp;
            }
        }
        return null;
    }
}

