/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.lobby;

import java.io.File;
import java.io.IOException;
import net.lunark.io.ServerEssentials;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LobbyConfig {
    private static File file;
    private static FileConfiguration config;

    public static void setup() {
        File configFolder = new File(ServerEssentials.getInstance().getDataFolder(), "config/lobby");
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        if (!(file = new File(configFolder, "lobby.yml")).exists()) {
            try {
                file.createNewFile();
                config = YamlConfiguration.loadConfiguration((File)file);
                config.set("cooldown", (Object)5);
                config.set("animation", (Object)true);
                config.set("perWorld", (Object)false);
                config.set("teleportOnJoin", (Object)false);
                config.save(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        config = YamlConfiguration.loadConfiguration((File)file);
    }

    public static int getCooldown() {
        return config.getInt("cooldown", 5);
    }

    public static boolean isAnimationEnabled() {
        return config.getBoolean("animation", true);
    }

    public static boolean isPerWorld() {
        return config.getBoolean("perWorld", false);
    }

    public static boolean isTeleportOnJoin() {
        return config.getBoolean("teleportOnJoin", false);
    }

    public static void reload() {
        config = YamlConfiguration.loadConfiguration((File)file);
    }
}

