/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.lobby;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.lunark.io.lobby.LobbyConfig;
import net.lunark.io.lobby.LobbyMessages;
import net.lunark.io.lobby.LobbyStorage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LobbyCommand
implements CommandExecutor {
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(LobbyMessages.get("only-players"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            long last;
            int secondsLeft;
            if (!player.hasPermission("serveressentials.lobby")) {
                player.sendMessage(LobbyMessages.get("no-permission"));
                return true;
            }
            if (!LobbyStorage.hasLobby(player.getWorld().getName())) {
                player.sendMessage(LobbyMessages.get("no-lobby"));
                return true;
            }
            int cooldownTime = LobbyConfig.getCooldown();
            long now = System.currentTimeMillis();
            if (this.cooldowns.containsKey(player.getUniqueId()) && (secondsLeft = (int)(((last = this.cooldowns.get(player.getUniqueId()).longValue()) + (long)(cooldownTime * 1000) - now) / 1000L)) > 0) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("time", String.valueOf(secondsLeft));
                player.sendMessage(LobbyMessages.getWithPlaceholders("cooldown-active", placeholders));
                return true;
            }
            this.cooldowns.put(player.getUniqueId(), now);
            Location lobby = LobbyStorage.getLobby(player.getWorld().getName());
            player.teleport(lobby);
            player.sendMessage(LobbyMessages.get("teleport-lobby"));
            return true;
        }
        String sub = args[0].toLowerCase();
        if (sub.equals("set")) {
            if (!player.hasPermission("serveressentials.lobby.set")) {
                player.sendMessage(LobbyMessages.get("no-permission"));
                return true;
            }
            if (args.length == 2 && args[1].equalsIgnoreCase("world")) {
                if (!LobbyConfig.isPerWorld()) {
                    player.sendMessage(LobbyMessages.get("no-permission"));
                    return true;
                }
                String worldName = player.getWorld().getName();
                LobbyStorage.setWorldLobby(worldName, player.getLocation());
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("world", worldName);
                player.sendMessage(LobbyMessages.getWithPlaceholders("world-set", placeholders));
                return true;
            }
            LobbyStorage.setLobby(player.getLocation());
            player.sendMessage(LobbyMessages.get("set-lobby"));
        } else if (sub.equals("remove")) {
            if (!player.hasPermission("serveressentials.lobby.remove")) {
                player.sendMessage(LobbyMessages.get("no-permission"));
                return true;
            }
            if (args.length == 2 && args[1].equalsIgnoreCase("world") && LobbyConfig.isPerWorld()) {
                String worldName = player.getWorld().getName();
                LobbyStorage.removeLobby(worldName);
            } else {
                LobbyStorage.removeLobby(null);
            }
            player.sendMessage(LobbyMessages.get("removed-lobby"));
        } else if (sub.equals("world")) {
            if (!player.hasPermission("serveressentials.lobby.world")) {
                player.sendMessage(LobbyMessages.get("no-permission"));
                return true;
            }
            if (!LobbyConfig.isPerWorld()) {
                player.sendMessage(LobbyMessages.get("no-permission"));
                return true;
            }
            if (args.length < 2) {
                player.sendMessage(LobbyMessages.get("no-lobby"));
                return true;
            }
            String worldName = args[1];
            if (Bukkit.getWorld((String)worldName) == null) {
                player.sendMessage(LobbyMessages.get("no-lobby"));
                return true;
            }
            LobbyStorage.setWorldLobby(worldName, player.getLocation());
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("world", worldName);
            player.sendMessage(LobbyMessages.getWithPlaceholders("world-set", placeholders));
        } else {
            player.sendMessage(LobbyMessages.get("no-permission"));
        }
        return true;
    }
}

