/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.economy;

import java.io.File;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.ServerEssentials;
import net.lunark.io.economy.ShopGUIManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class ShopCommand
implements CommandExecutor {
    private static final MiniMessage mm = MiniMessage.miniMessage();
    private static File shopFile = new File(ServerEssentials.getInstance().getDataFolder(), "messages/shop.yml");
    private static FileConfiguration shopMessages;

    private Component getMessage(String path, String defaultMsg) {
        String raw = shopMessages.getString(path, defaultMsg);
        return mm.deserialize(raw);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.getMessage("errors.only-players", "<red>Only players can use this command."));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            ShopGUIManager.loadShopConfigs(new File(ServerEssentials.getInstance().getDataFolder(), "Shop"));
            sender.sendMessage(this.getMessage("messages.reloaded", "<green>Shop reloaded."));
        } else {
            ShopGUIManager.openMainGUI(player);
        }
        return true;
    }

    public static void reloadMessages() {
        shopMessages = YamlConfiguration.loadConfiguration((File)shopFile);
    }

    static {
        if (!shopFile.exists()) {
            shopFile.getParentFile().mkdirs();
            ServerEssentials.getInstance().saveResource("messages/shop.yml", false);
        }
        shopMessages = YamlConfiguration.loadConfiguration((File)shopFile);
    }
}

