/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.economy;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.ServerEssentials;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PayToggleCommand
implements CommandExecutor {
    private static final Set<UUID> toggled = new HashSet<UUID>();
    private static final MiniMessage mm = MiniMessage.miniMessage();
    private static File messagesFile;
    private static FileConfiguration messagesConfig;

    public PayToggleCommand() {
        PayToggleCommand.loadMessages();
    }

    public static void loadMessages() {
        messagesFile = new File(ServerEssentials.getInstance().getDataFolder(), "messages/economy.yml");
        if (!messagesFile.exists()) {
            messagesFile.getParentFile().mkdirs();
            ServerEssentials.getInstance().saveResource("messages/economy.yml", false);
        }
        messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
    }

    public static boolean hasPaymentsDisabled(Player player) {
        return toggled.contains(player.getUniqueId());
    }

    private Component format(String path) {
        return mm.deserialize(messagesConfig.getString(path, path));
    }

    private Component format(String path, Object ... placeholders) {
        String raw = messagesConfig.getString(path, path);
        if (placeholders.length % 2 != 0) {
            return mm.deserialize(raw);
        }
        for (int i = 0; i < placeholders.length; i += 2) {
            raw = raw.replace(String.valueOf(placeholders[i]), String.valueOf(placeholders[i + 1]));
        }
        return mm.deserialize(raw);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.format("pay.only-players"));
            return true;
        }
        Player player = (Player)sender;
        UUID uuid = player.getUniqueId();
        if (toggled.contains(uuid)) {
            toggled.remove(uuid);
            player.sendMessage(this.format("pay.toggle-enabled"));
        } else {
            toggled.add(uuid);
            player.sendMessage(this.format("pay.toggle-disabled"));
        }
        return true;
    }
}

