/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.economy;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.ServerEssentials;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class CoinFlipCommand
implements CommandExecutor,
TabCompleter {
    private final Random random = new Random();
    private static final MiniMessage mm = MiniMessage.miniMessage();
    private static File messagesFile;
    private static FileConfiguration messagesConfig;
    private final Economy economy;

    public CoinFlipCommand(Economy economy) {
        this.economy = economy;
        CoinFlipCommand.loadMessages();
    }

    public static void loadMessages() {
        messagesFile = new File(ServerEssentials.getInstance().getDataFolder(), "messages/economy.yml");
        if (!messagesFile.exists()) {
            messagesFile.getParentFile().mkdirs();
            ServerEssentials.getInstance().saveResource("messages/economy.yml", false);
        }
        messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
    }

    private Component prefix() {
        return mm.deserialize(messagesConfig.getString("prefix", "<blue><bold>[SE]</bold> </blue>"));
    }

    private Component getMessage(String path, Object ... placeholders) {
        String raw = messagesConfig.getString(path, path);
        if (placeholders.length % 2 != 0) {
            return mm.deserialize(raw);
        }
        for (int i = 0; i < placeholders.length; i += 2) {
            raw = raw.replace(String.valueOf(placeholders[i]), String.valueOf(placeholders[i + 1]));
        }
        return mm.deserialize(raw);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        double amount;
        if (!(sender instanceof Player)) {
            sender.sendMessage(mm.deserialize("<red>Only players can use this command!"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage(this.prefix().append(this.getMessage("coinflip.usage", new Object[0])));
            return true;
        }
        try {
            amount = Double.parseDouble(args[0]);
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.prefix().append(this.getMessage("coinflip.invalid-amount", new Object[0])));
            return true;
        }
        if (amount <= 0.0) {
            player.sendMessage(this.prefix().append(this.getMessage("coinflip.amount-positive", new Object[0])));
            return true;
        }
        double balance = this.economy.getBalance((OfflinePlayer)player);
        if (balance < amount) {
            player.sendMessage(this.prefix().append(this.getMessage("coinflip.not-enough-money", "{balance}", String.format("%.2f", balance), "{amount}", String.format("%.2f", amount))));
            return true;
        }
        boolean win = this.random.nextBoolean();
        if (win) {
            this.economy.depositPlayer((OfflinePlayer)player, amount);
            player.sendMessage(this.prefix().append(this.getMessage("coinflip.win", "{amount}", String.format("%.2f", amount))));
        } else {
            this.economy.withdrawPlayer((OfflinePlayer)player, amount);
            player.sendMessage(this.prefix().append(this.getMessage("coinflip.lose", "{amount}", String.format("%.2f", amount))));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (args.length == 1) {
            List<String> suggestions = Arrays.asList("10", "50", "100", "500", "1000");
            ArrayList<String> completions = new ArrayList<String>();
            String input = args[0].toLowerCase();
            for (String s : suggestions) {
                if (!s.startsWith(input)) continue;
                completions.add(s);
            }
            return completions;
        }
        return List.of();
    }
}

