/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.config;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.lunark.io.pw.PlayerWarp;
import net.lunark.io.util.ChatUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GUIConfig {
    private FileConfiguration config;

    public GUIConfig(FileConfiguration config) {
        this.config = config;
        this.loadDefaults();
    }

    private void loadDefaults() {
        String base;
        String basePath;
        if (!this.config.contains("gui.editwarp.title")) {
            this.config.set("gui.editwarp.title", (Object)"&eEdit Warp: %warpname%");
        }
        if (!this.config.contains((basePath = "gui.editwarp.items.") + "name.material")) {
            this.config.set(basePath + "name.material", (Object)"NAME_TAG");
        }
        if (!this.config.contains(basePath + "name.displayname")) {
            this.config.set(basePath + "name.displayname", (Object)"&bChange Name");
        }
        if (!this.config.contains(basePath + "name.lore")) {
            this.config.set(basePath + "name.lore", List.of("&7Current: &f%current%"));
        }
        if (!this.config.contains(basePath + "description.material")) {
            this.config.set(basePath + "description.material", (Object)"PAPER");
        }
        if (!this.config.contains(basePath + "description.displayname")) {
            this.config.set(basePath + "description.displayname", (Object)"&bChange Description");
        }
        if (!this.config.contains(basePath + "description.lore")) {
            this.config.set(basePath + "description.lore", List.of("&7Current: &f%current%"));
        }
        if (!this.config.contains(basePath + "category.material")) {
            this.config.set(basePath + "category.material", (Object)"BOOK");
        }
        if (!this.config.contains(basePath + "category.displayname")) {
            this.config.set(basePath + "category.displayname", (Object)"&bChange Category");
        }
        if (!this.config.contains(basePath + "category.lore")) {
            this.config.set(basePath + "category.lore", List.of("&7Current: &f%current%"));
        }
        if (!this.config.contains(basePath + "icon.material")) {
            this.config.set(basePath + "icon.material", (Object)"PLAYER_HEAD");
        }
        if (!this.config.contains(basePath + "icon.displayname")) {
            this.config.set(basePath + "icon.displayname", (Object)"&bChange Icon");
        }
        if (!this.config.contains(basePath + "icon.lore")) {
            this.config.set(basePath + "icon.lore", List.of("&7Click with any item in hand"));
        }
        if (!this.config.contains(basePath + "location.material")) {
            this.config.set(basePath + "location.material", (Object)"COMPASS");
        }
        if (!this.config.contains(basePath + "location.displayname")) {
            this.config.set(basePath + "location.displayname", (Object)"&bSet New Location");
        }
        if (!this.config.contains(basePath + "location.lore")) {
            this.config.set(basePath + "location.lore", List.of("&7Current location will be updated"));
        }
        if (!this.config.contains(basePath + "cooldown.material")) {
            this.config.set(basePath + "cooldown.material", (Object)"CLOCK");
        }
        if (!this.config.contains(basePath + "cooldown.displayname")) {
            this.config.set(basePath + "cooldown.displayname", (Object)"&bSet Cooldown");
        }
        if (!this.config.contains(basePath + "cooldown.lore")) {
            this.config.set(basePath + "cooldown.lore", List.of("&7Current: &f%current%s"));
        }
        if (!this.config.contains("gui.category.title")) {
            this.config.set("gui.category.title", (Object)"\u00a79Choose a Category");
        }
        if (!this.config.contains("gui.category.item.material")) {
            this.config.set("gui.category.item.material", (Object)"BOOK");
        }
        if (!this.config.contains("gui.category.item.displayname")) {
            this.config.set("gui.category.item.displayname", (Object)"\u00a7b%category%");
        }
        if (!this.config.contains("categories")) {
            this.config.set("categories", List.of("Default", "Admin", "Fun"));
        }
        if (!this.config.contains("gui.warplist.title")) {
            this.config.set("gui.warplist.title", (Object)"&aWarps: %category%");
        }
        if (!this.config.contains((base = "gui.warplist.item.") + "material")) {
            this.config.set(base + "material", (Object)"ENDER_PEARL");
        }
        if (!this.config.contains(base + "displayname")) {
            this.config.set(base + "displayname", (Object)"&f%warpname%");
        }
        if (!this.config.contains(base + "lore")) {
            this.config.set(base + "lore", List.of("&7Owner: &f%owner%", "&7%description%"));
        }
    }

    public String getWarpListTitle(String category) {
        return ChatUtil.color(this.config.getString("gui.warplist.title", "&aWarps: %category%").replace("%category%", category));
    }

    public String getCategoryGUITitle() {
        return ChatUtil.color(this.config.getString("gui.category.title", "\u00a79Choose a Category"));
    }

    public List<String> getCategories() {
        return this.config.getStringList("categories");
    }

    public ItemStack getCategoryItem(String category) {
        Material material = Material.getMaterial((String)this.config.getString("gui.category.item.material", "BOOK"));
        if (material == null) {
            material = Material.BOOK;
        }
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        String displayName = this.config.getString("gui.category.item.displayname", "\u00a7b%category%");
        displayName = displayName.replace("%category%", category);
        meta.setDisplayName(ChatUtil.color(displayName));
        item.setItemMeta(meta);
        return item;
    }

    public String getWarpsGUITitlePrefix() {
        return ChatUtil.color(this.config.getString("gui.warplist.title-prefix", "\u00a7aWarps: "));
    }

    public void reload(FileConfiguration newConfig) {
        this.config = newConfig;
        this.loadDefaults();
    }

    public String getMessage(String key, String defaultMsg) {
        return ChatUtil.color(this.config.getString("messages." + key, defaultMsg));
    }

    public String getEditWarpGUITitlePrefix() {
        return ChatUtil.color(this.config.getString("gui.editwarp.title-prefix", "\u00a7eEdit Warp: "));
    }

    public ItemStack getWarpListItem(PlayerWarp warp) {
        String base = "gui.warplist.item.";
        Material material = Material.getMaterial((String)this.config.getString(base + "material", "ENDER_PEARL"));
        if (material == null) {
            material = Material.ENDER_PEARL;
        }
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        String displayName = this.config.getString(base + "displayname", "&f%warpname%");
        displayName = displayName.replace("%warpname%", warp.getName());
        meta.setDisplayName(ChatUtil.color(displayName));
        List loreRaw = this.config.getStringList(base + "lore");
        ArrayList<String> lore = new ArrayList<String>();
        String ownerName = Bukkit.getOfflinePlayer((UUID)warp.getOwner()).getName();
        String description = warp.getDescription() != null && !warp.getDescription().isEmpty() ? warp.getDescription() : "";
        for (String line : loreRaw) {
            line = line.replace("%owner%", ownerName != null ? ownerName : "Unknown").replace("%description%", description);
            lore.add(ChatUtil.color(line));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public String getEditWarpTitle(String warpName) {
        return ChatUtil.color(this.config.getString("gui.editwarp.title", "&eEdit Warp: %warpname%").replace("%warpname%", warpName));
    }

    public ItemStack getEditWarpItem(String key, String currentValue) {
        String base = "gui.editwarp.items." + key + ".";
        Material material = Material.getMaterial((String)this.config.getString(base + "material", "PAPER"));
        if (material == null) {
            material = Material.PAPER;
        }
        String displayName = this.config.getString(base + "displayname", "Item");
        List loreRaw = this.config.getStringList(base + "lore");
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : loreRaw) {
            lore.add(ChatUtil.color(line.replace("%current%", currentValue == null ? "" : currentValue)));
        }
        meta.setDisplayName(ChatUtil.color(displayName));
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }
}

