/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.auction;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.lunark.io.ServerEssentials;
import net.lunark.io.auction.AuctionItem;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GUIManager {
    private final ServerEssentials plugin;
    private final int itemsPerPage = 36;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private final Map<Player, Map<Integer, AuctionItem>> auctionGUIMap = new HashMap<Player, Map<Integer, AuctionItem>>();
    private final Map<Player, Map<Integer, AuctionItem>> playerItemsGUIMap = new HashMap<Player, Map<Integer, AuctionItem>>();
    private final Map<Player, AuctionItem> pendingRemove = new HashMap<Player, AuctionItem>();
    private final LegacyComponentSerializer legacy = LegacyComponentSerializer.legacySection();

    public GUIManager(ServerEssentials plugin) {
        this.plugin = plugin;
    }

    private void addBorder(Inventory inv) {
        int i;
        ItemStack glass = this.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, this.plugin.getAuctionMessagesManager().getMessage("gui.border", new String[0]));
        int size = inv.getSize();
        for (i = 0; i < 9; ++i) {
            inv.setItem(i, glass);
        }
        for (i = size - 9; i < size; ++i) {
            inv.setItem(i, glass);
        }
        for (i = 9; i < size - 9; ++i) {
            if (i % 9 != 0 && i % 9 != 8) continue;
            inv.setItem(i, glass);
        }
    }

    public void openAuctionGUI(Player player, int page) {
        List<AuctionItem> items = this.plugin.getAuctionManager().getAuctionItems();
        Component titleMM = this.plugin.getAuctionMessagesManager().getMessage("gui.auction.title", "%page%", String.valueOf(page));
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)this.legacy.serialize(this.plugin.getAuctionMessagesManager().getMessage("gui.auction.title", "%page%", String.valueOf(page))));
        this.addBorder(inv);
        HashMap<Integer, AuctionItem> slotMap = new HashMap<Integer, AuctionItem>();
        int start = (page - 1) * 36;
        int end = Math.min(start + 36, items.size());
        for (int i = start; i < end; ++i) {
            AuctionItem auctionItem = items.get(i);
            ItemStack item = auctionItem.getItem().clone();
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(this.legacy.serialize(this.plugin.getAuctionMessagesManager().getMessage("gui.auction.item-name", "%price%", String.valueOf(auctionItem.getPrice()))));
            List<Component> loreMM = List.of(this.plugin.getAuctionMessagesManager().getMessage("gui.auction.item-lore.seller", "%seller%", Bukkit.getOfflinePlayer((UUID)auctionItem.getSeller()).getName()), this.plugin.getAuctionMessagesManager().getMessage("gui.auction.item-lore.expires", "%expires%", this.sdf.format(new Date(auctionItem.getExpiration()))), this.plugin.getAuctionMessagesManager().getMessage("gui.auction.item-lore.click", new String[0]));
            ArrayList<String> lore = new ArrayList<String>();
            for (Component c : loreMM) {
                lore.add(this.legacy.serialize(c));
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
            int slot = i - start + 10;
            if (slot >= 45) {
                ++slot;
            }
            inv.setItem(slot, item);
            slotMap.put(slot, auctionItem);
        }
        this.auctionGUIMap.put(player, slotMap);
        inv.setItem(45, this.createGuiItem(Material.ARROW, this.plugin.getAuctionMessagesManager().getMessage("gui.navigation.prev", new String[0])));
        inv.setItem(0, this.createGuiItem(Material.PAPER, this.plugin.getAuctionMessagesManager().getMessage("gui.navigation.refresh", new String[0])));
        inv.setItem(4, this.createPlayerBalanceItem(player));
        inv.setItem(8, this.createGuiItem(Material.CHEST, this.plugin.getAuctionMessagesManager().getMessage("gui.navigation.my-items", new String[0])));
        inv.setItem(49, this.createGuiItem(Material.BARRIER, this.plugin.getAuctionMessagesManager().getMessage("gui.navigation.close", new String[0])));
        inv.setItem(53, this.createGuiItem(Material.ARROW, this.plugin.getAuctionMessagesManager().getMessage("gui.navigation.next", new String[0])));
        player.openInventory(inv);
    }

    private ItemStack createPlayerBalanceItem(Player player) {
        double balance = this.plugin.getVaultEconomy().getBalance((OfflinePlayer)player);
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta meta = skull.getItemMeta();
        meta.setDisplayName(this.legacy.serialize(this.plugin.getAuctionMessagesManager().getMessage("gui.balance", "%balance%", String.valueOf(balance))));
        skull.setItemMeta(meta);
        return skull;
    }

    public void openPlayerItemsGUI(Player player, int page) {
        List<AuctionItem> items = this.plugin.getAuctionManager().getPlayerItems(player.getUniqueId());
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)this.legacy.serialize(this.plugin.getAuctionMessagesManager().getMessage("gui.my-items.title", "%page%", String.valueOf(page))));
        this.addBorder(inv);
        HashMap<Integer, AuctionItem> slotMap = new HashMap<Integer, AuctionItem>();
        int start = (page - 1) * 36;
        int end = Math.min(start + 36, items.size());
        for (int i = start; i < end; ++i) {
            AuctionItem auctionItem = items.get(i);
            ItemStack item = auctionItem.getItem().clone();
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(this.legacy.serialize(this.plugin.getAuctionMessagesManager().getMessage("gui.my-items.item-name", "%price%", String.valueOf(auctionItem.getPrice()))));
            List<Component> loreMM = List.of(this.plugin.getAuctionMessagesManager().getMessage("gui.my-items.item-lore.price", "%price%", String.valueOf(auctionItem.getPrice())), this.plugin.getAuctionMessagesManager().getMessage("gui.my-items.item-lore.expires", "%expires%", this.sdf.format(new Date(auctionItem.getExpiration()))), this.plugin.getAuctionMessagesManager().getMessage("gui.my-items.item-lore.click", new String[0]));
            ArrayList<String> lore = new ArrayList<String>();
            for (Component c : loreMM) {
                lore.add(this.legacy.serialize(c));
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
            int slot = i - start + 10;
            if (slot >= 45) {
                ++slot;
            }
            inv.setItem(slot, item);
            slotMap.put(slot, auctionItem);
        }
        this.playerItemsGUIMap.put(player, slotMap);
        inv.setItem(45, this.createGuiItem(Material.ARROW, this.plugin.getAuctionMessagesManager().getMessage("gui.navigation.prev", new String[0])));
        inv.setItem(53, this.createGuiItem(Material.ARROW, this.plugin.getAuctionMessagesManager().getMessage("gui.navigation.next", new String[0])));
        inv.setItem(49, this.createGuiItem(Material.BARRIER, this.plugin.getAuctionMessagesManager().getMessage("gui.navigation.close", new String[0])));
        player.openInventory(inv);
    }

    public void openRemoveConfirmGUI(Player player, AuctionItem item) {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)this.legacy.serialize(this.plugin.getAuctionMessagesManager().getMessage("gui.remove.title", new String[0])));
        inv.setItem(11, this.createGuiItem(Material.GREEN_WOOL, this.plugin.getAuctionMessagesManager().getMessage("gui.remove.confirm", new String[0])));
        inv.setItem(15, this.createGuiItem(Material.RED_WOOL, this.plugin.getAuctionMessagesManager().getMessage("gui.remove.cancel", new String[0])));
        this.pendingRemove.put(player, item);
        player.openInventory(inv);
    }

    public AuctionItem getItemToRemove(Player player) {
        return this.pendingRemove.remove(player);
    }

    private ItemStack createGuiItem(Material mat, Component name) {
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(this.legacy.serialize(name));
        item.setItemMeta(meta);
        return item;
    }

    public AuctionItem getAuctionItem(Player player, int slot) {
        return (AuctionItem)this.auctionGUIMap.getOrDefault(player, Map.of()).get(slot);
    }

    public AuctionItem getPlayerItem(Player player, int slot) {
        return (AuctionItem)this.playerItemsGUIMap.getOrDefault(player, Map.of()).get(slot);
    }
}

